/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.undo;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.undo.BlockHistory;
import oreexcavation.undo.RestoreResult;
import oreexcavation.utils.BigItemStack;
import oreexcavation.utils.BlockPos;
import oreexcavation.utils.XPHelper;

public class ExcavateHistory {
    private final List<BlockHistory> history = new ArrayList<BlockHistory>();
    private final List<BigItemStack> stacks = new ArrayList<BigItemStack>();
    private long experience = 0L;
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private final int dimension;

    public ExcavateHistory(int dimension) {
        this.dimension = dimension;
    }

    public BlockHistory recordPosition(World world, BlockPos pos) {
        Block block = world.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
        int meta = world.func_72805_g(pos.getX(), pos.getY(), pos.getZ());
        TileEntity tile = world.func_147438_o(pos.getX(), pos.getZ(), pos.getY());
        NBTTagCompound tileData = null;
        if (tile != null) {
            tileData = new NBTTagCompound();
            tile.func_145841_b(tileData);
        }
        return new BlockHistory(pos, block, meta, tileData);
    }

    public void addRecordedBlock(BlockHistory block) {
        if (this.history.contains(block) || block.block == Blocks.field_150350_a) {
            return;
        }
        this.history.add(0, block);
    }

    public void setRecievedStacks(List<BigItemStack> items) {
        this.stacks.clear();
        for (BigItemStack s : items) {
            this.stacks.add(s.copy());
        }
    }

    public void setRecievedXP(long xp) {
        this.experience = xp;
    }

    public RestoreResult canRestore(MinecraftServer server, EntityPlayer player) {
        WorldServer world = server.func_71218_a(this.dimension);
        if (!player.field_71075_bZ.field_75098_d) {
            if (XPHelper.getPlayerXP(player) < this.experience) {
                return RestoreResult.INVALID_XP;
            }
            int[] req = new int[this.stacks.size()];
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invoStack = player.field_71071_by.func_70301_a(i);
                if (invoStack == null) continue;
                for (int n = 0; n < req.length; ++n) {
                    if (!this.stacks.get(n).equals(invoStack)) continue;
                    int n2 = n;
                    req[n2] = req[n2] + invoStack.field_77994_a;
                }
            }
            for (int n = 0; n < req.length; ++n) {
                if (req[n] >= this.stacks.get((int)n).stackSize) continue;
                return RestoreResult.INVALID_ITEMS;
            }
        }
        for (BlockHistory hist : this.history) {
            if (world.func_147439_a(hist.pos.getX(), hist.pos.getY(), hist.pos.getZ()) != Blocks.field_150350_a) {
                return RestoreResult.OBSTRUCTED;
            }
            if (world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)hist.pos.getX(), (double)hist.pos.getY(), (double)hist.pos.getZ(), (double)((float)hist.pos.getX() + 1.0f), (double)((float)hist.pos.getY() + 1.0f), (double)((float)hist.pos.getZ() + 1.0f))).size() <= 0) continue;
            return RestoreResult.OBSTRUCTED;
        }
        return RestoreResult.SUCCESS;
    }

    public boolean tickRestore(MinecraftServer server, EntityPlayer player) {
        this.timer.reset();
        this.timer.start();
        if (!player.field_71075_bZ.field_75098_d && this.stacks.size() > 0) {
            XPHelper.addXP(player, -this.experience, true);
            Iterator<BigItemStack> iterStacks = this.stacks.iterator();
            while (iterStacks.hasNext()) {
                BigItemStack stack = iterStacks.next();
                for (int i = 0; i < player.field_71071_by.func_70302_i_() && stack.stackSize > 0; ++i) {
                    ItemStack invoStack = player.field_71071_by.func_70301_a(i);
                    if (!stack.equals(invoStack)) continue;
                    int num = Math.min(stack.stackSize, invoStack.field_77994_a);
                    player.field_71071_by.func_70298_a(i, num);
                    stack.stackSize -= num;
                }
                iterStacks.remove();
            }
        }
        Iterator<BlockHistory> iterator = this.history.iterator();
        WorldServer world = server.func_71218_a(this.dimension);
        while (iterator.hasNext() && (!ExcavationSettings.tpsGuard || this.timer.elapsed(TimeUnit.MILLISECONDS) <= 40L)) {
            BlockHistory entry = iterator.next();
            entry.restoreBlock((World)world);
            iterator.remove();
        }
        this.timer.stop();
        return this.history.size() <= 0;
    }
}

