/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.groups;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.OreIngredient;
import org.apache.logging.log4j.Level;

public class ItemEntry {
    public final ResourceLocation idName;
    public final OreIngredient oreDict;
    public final int subType;

    public ItemEntry(ResourceLocation idName, int subType) {
        this.idName = idName;
        this.subType = subType;
        this.oreDict = null;
    }

    public ItemEntry(String oreDict) {
        this.oreDict = StringUtils.func_151246_b((String)oreDict) ? null : new OreIngredient(oreDict);
        this.idName = null;
        this.subType = -1;
    }

    public boolean checkMatch(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.idName == null) {
            return this.checkOre(stack);
        }
        ResourceLocation r = new ResourceLocation(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        return this.idName.equals((Object)r) && (this.subType < 0 || this.subType == Short.MAX_VALUE || this.subType == stack.func_77960_j());
    }

    private boolean checkOre(ItemStack stack) {
        return this.oreDict != null && this.oreDict.apply(stack);
    }

    public static ItemEntry readFromString(String s) {
        if (s == null || s.length() <= 0) {
            return null;
        }
        String[] split = s.split(":");
        if (split.length <= 0 || split.length > 3) {
            return null;
        }
        if (split.length == 1) {
            return new ItemEntry(split[0]);
        }
        if (split.length == 2) {
            return new ItemEntry(new ResourceLocation(split[0], split[1]), -1);
        }
        try {
            return new ItemEntry(new ResourceLocation(split[0], split[1]), Integer.parseInt(split[2]));
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.ERROR, "Unable to read metadata value for Item Entry \"" + s + "\":", (Throwable)e);
            return null;
        }
    }
}

