/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.groups;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.OreIngredient;
import org.apache.logging.log4j.Level;

public class BlockEntry {
    public final ResourceLocation idName;
    public final OreIngredient oreDict;
    public final int subType;

    public BlockEntry(ResourceLocation idName, int subType) {
        this.idName = idName;
        this.subType = subType;
        this.oreDict = null;
    }

    public BlockEntry(String oreDict) {
        this.oreDict = StringUtils.func_151246_b((String)oreDict) ? null : new OreIngredient(oreDict);
        this.idName = null;
        this.subType = -1;
    }

    public boolean checkMatch(Block block, int metadata) {
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        if (this.idName == null) {
            return this.checkOre(block, metadata);
        }
        ResourceLocation r = new ResourceLocation(Block.field_149771_c.func_148750_c((Object)block));
        return this.idName.equals((Object)r) && (this.subType < 0 || this.subType == Short.MAX_VALUE || this.subType == metadata);
    }

    private boolean checkOre(Block block, int metadata) {
        Item iBlock = Item.func_150898_a((Block)block);
        return this.oreDict != null && iBlock != null && this.oreDict.apply(new ItemStack(iBlock, 1, metadata));
    }

    public static BlockEntry readFromString(String s) {
        if (s == null || s.length() <= 0) {
            return null;
        }
        String[] split = s.split(":");
        if (split.length <= 0 || split.length > 3) {
            return null;
        }
        if (split.length == 1) {
            return new BlockEntry(split[0]);
        }
        if (split.length == 2) {
            return new BlockEntry(new ResourceLocation(split[0], split[1]), -1);
        }
        try {
            return new BlockEntry(new ResourceLocation(split[0], split[1]), Integer.parseInt(split[2]));
        }
        catch (Exception e) {
            OreExcavation.logger.log(Level.ERROR, "Unable to read metadata value for Block Entry \"" + s + "\":", (Throwable)e);
            return null;
        }
    }
}

