/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BottlingMachineDriver
extends DriverTileEntity {
    public ManagedEnvironment createEnvironment(World w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityBottlingMachine) {
            int offsetY = ((TileEntityBottlingMachine)te).offset[1];
            int pos = ((TileEntityBottlingMachine)te).pos;
            if (offsetY == 0 && pos != 0 && pos != 2) {
                TileEntityBottlingMachine bottle = (TileEntityBottlingMachine)te;
                return new BottlingMachineEnvironment(w, bottle.field_145851_c - bottle.offset[0], bottle.field_145848_d - bottle.offset[1], bottle.field_145849_e - bottle.offset[2], TileEntityBottlingMachine.class);
            }
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityBottlingMachine.class;
    }

    public class BottlingMachineEnvironment
    extends ManagedEnvironmentIE<TileEntityBottlingMachine> {
        public String preferredName() {
            return "ie_bottling_machine";
        }

        public int priority() {
            return 1000;
        }

        public BottlingMachineEnvironment(World w, int x, int y, int z, Class<? extends TileEntityIEBase> teClass) {
            super(w, x, y, z, teClass);
        }

        public void onConnect(Node node) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.getTileEntity();
            if (master != null) {
                master.computerControlled = true;
                master.computerOn = true;
            }
        }

        public void onDisconnect(Node node) {
            TileEntityBottlingMachine te = (TileEntityBottlingMachine)this.getTileEntity();
            if (te != null) {
                te.computerControlled = false;
            }
        }

        @Callback(doc="function():table -- returns the internal fluid tank")
        public Object[] getFluid(Context context, Arguments args) {
            return new Object[]{Utils.saveFluidTank(((TileEntityBottlingMachine)this.getTileEntity()).tank)};
        }

        @Callback(doc="function(pos:int):table -- returns the empty cannister at the specified position")
        public Object[] getEmptyCannister(Context context, Arguments args) {
            int param = args.checkInteger(0);
            if (param < 1 || param > 5) {
                throw new IllegalArgumentException("Only 1-5 are valid cannister positions");
            }
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.getTileEntity();
            int id = master.getEmptyCannister(param - 1);
            Map<String, Object> map = Utils.saveStack(master.inventory[id]);
            map.put("process", master.process[id]);
            return new Object[]{map};
        }

        @Callback(doc="function():int -- returns amount of empty cannisters")
        public Object[] getEmptyCannisterCount(Context context, Arguments args) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.getTileEntity();
            return new Object[]{master.getEmptyCount()};
        }

        @Callback(doc="function(pos:int):table -- returns the filled cannister at the specified position")
        public Object[] getFilledCannister(Context context, Arguments args) {
            int param = args.checkInteger(0);
            if (param < 1 || param > 5) {
                throw new IllegalArgumentException("Only 1-5 are valid cannister positions");
            }
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.getTileEntity();
            int id = master.getFilledCannister(param - 1);
            Map<String, Object> map = Utils.saveStack(master.inventory[id]);
            map.put("process", master.process[id]);
            return new Object[]{map};
        }

        @Callback(doc="function():int -- returns the amount of filled cannisters")
        public Object[] getFilledCannisterCount(Context context, Arguments args) {
            TileEntityBottlingMachine master = (TileEntityBottlingMachine)this.getTileEntity();
            return new Object[]{master.getFilledCount()};
        }

        @Callback(doc="function(on:boolean) -- turns the bottling machine on or off")
        public Object[] setEnabled(Context context, Arguments args) {
            boolean on;
            ((TileEntityBottlingMachine)this.getTileEntity()).computerOn = on = args.checkBoolean(0);
            return null;
        }

        @Callback(doc="function():int -- returns the maximum amount of energy that can be stored")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityBottlingMachine)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():int -- returns the amount of energy stored")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityBottlingMachine)this.getTileEntity()).energyStorage.getEnergyStored()};
        }
    }
}

