/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.IWireCoil;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemWireCoil
extends ItemIEBase
implements IWireCoil {
    public ItemWireCoil() {
        super("coil", 64, "copper", "electrum", "HV", "rope", "structural");
    }

    @Override
    public WireType getWireType(ItemStack stack) {
        switch (stack.func_77960_j()) {
            default: {
                return WireType.COPPER;
            }
            case 1: {
                return WireType.ELECTRUM;
            }
            case 2: {
                return WireType.STEEL;
            }
            case 3: {
                return WireType.STRUCTURE_ROPE;
            }
            case 4: 
        }
        return WireType.STRUCTURE_STEEL;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        if (stack.func_77960_j() > 2) {
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.coil.construction0"));
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.coil.construction1"));
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("linkingPos") && (link = stack.func_77978_p().func_74759_k("linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            if (!((IImmersiveConnectable)tileEntity).canConnectCable(this.getWireType(stack), target)) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongCable", new Object[0]));
                return false;
            }
            if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.field_73011_w.field_76574_g, x, y, z});
                target.writeToNBT(stack.func_77978_p());
            } else {
                WireType type = this.getWireType(stack);
                int[] pos = ItemNBTHelper.getIntArray(stack, "linkingPos");
                TileEntity tileEntityLinkingPos = world.func_147438_o(pos[1], pos[2], pos[3]);
                int distance = (int)Math.ceil(Math.sqrt((pos[1] - x) * (pos[1] - x) + (pos[2] - y) * (pos[2] - y) + (pos[3] - z) * (pos[3] - z)));
                if (pos[0] != world.field_73011_w.field_76574_g) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongDimension", new Object[0]));
                } else if (pos[1] == x && pos[2] == y && pos[3] == z) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.sameConnection", new Object[0]));
                } else if (distance > type.getMaxLength()) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.tooFar", new Object[0]));
                } else if (!(tileEntityLinkingPos instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntityLinkingPos).canConnectCable(this.getWireType(stack), target)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.invalidPoint", new Object[0]));
                } else {
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                    IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                    boolean connectionExists = false;
                    Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC(nodeHere));
                    if (outputs != null) {
                        for (ImmersiveNetHandler.Connection con : outputs) {
                            if (!con.end.equals((Object)Utils.toCC(nodeLink))) continue;
                            connectionExists = true;
                        }
                    }
                    if (connectionExists) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.connectionExists", new Object[0]));
                    } else {
                        Vec3 rtOff1;
                        Vec3 rtOff0 = nodeHere.getRaytraceOffset(nodeLink).func_72441_c((double)x, (double)y, (double)z);
                        boolean canSee = Utils.canBlocksSeeOther(world, new ChunkCoordinates(x, y, z), new ChunkCoordinates(pos[1], pos[2], pos[3]), rtOff0, rtOff1 = nodeLink.getRaytraceOffset(nodeHere).func_72441_c((double)pos[1], (double)pos[2], (double)pos[3]));
                        if (canSee) {
                            TargetingInfo targetLink = TargetingInfo.readFromNBT(stack.func_77978_p());
                            ImmersiveNetHandler.INSTANCE.addConnection(world, Utils.toCC(nodeHere), Utils.toCC(nodeLink), distance, type);
                            nodeHere.connectCable(type, target);
                            nodeLink.connectCable(type, targetLink);
                            IESaveData.setDirty(world.field_73011_w.field_76574_g);
                            player.func_71029_a((StatBase)IEAchievements.connectWire);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                            ((TileEntity)nodeHere).func_70296_d();
                            world.func_147452_c(x, y, z, ((TileEntity)nodeHere).func_145838_q(), -1, 0);
                            world.func_147471_g(x, y, z);
                            ((TileEntity)nodeLink).func_70296_d();
                            world.func_147452_c(pos[1], pos[2], pos[3], ((TileEntity)nodeLink).func_145838_q(), -1, 0);
                            world.func_147471_g(pos[1], pos[2], pos[3]);
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.cantSee", new Object[0]));
                        }
                    }
                }
                ItemNBTHelper.remove(stack, "linkingPos");
                ItemNBTHelper.remove(stack, "side");
                ItemNBTHelper.remove(stack, "hitX");
                ItemNBTHelper.remove(stack, "hitY");
                ItemNBTHelper.remove(stack, "hitZ");
            }
            return true;
        }
        return false;
    }
}

