/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCapacitorLV
extends TileEntityIEBase
implements IEnergyHandler,
IEBlockInterfaces.IBlockOverlayText {
    public int[] sideConfig = new int[]{-1, 0, -1, -1, -1, -1};
    EnergyStorage energyStorage = new EnergyStorage(this.getMaxStorage(), this.getMaxInput(), this.getMaxOutput());
    public int comparatorOutput = 0;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            for (i = 0; i < 6; ++i) {
                this.transferEnergy(i);
            }
            if (this.field_145850_b.func_82737_E() % 32L == (long)((this.field_145851_c ^ this.field_145849_e) & 0x1F) && (i = this.scaleStoredEnergyTo(15)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
        }
    }

    public int scaleStoredEnergyTo(int scale) {
        return (int)((float)scale * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    protected void transferEnergy(int side) {
        if (this.sideConfig[side] != 1) {
            return;
        }
        ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[side];
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
        if (tileEntity instanceof IEnergyReceiver) {
            this.energyStorage.modifyEnergyStored(-((IEnergyReceiver)tileEntity).receiveEnergy(fd.getOpposite(), Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored()), false));
        }
    }

    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public int getMaxStorage() {
        return Config.getInt("capacitorLV_storage");
    }

    public int getMaxInput() {
        return Config.getInt("capacitorLV_input");
    }

    public int getMaxOutput() {
        return Config.getInt("capacitorLV_output");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length < 6) {
            this.sideConfig = new int[6];
        }
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection fd) {
        return fd.ordinal() < this.sideConfig.length && this.sideConfig[fd.ordinal()] >= 0;
    }

    @Override
    public int extractEnergy(ForgeDirection fd, int amount, boolean simulate) {
        if (this.field_145850_b.field_72995_K || fd.ordinal() >= this.sideConfig.length || this.sideConfig[fd.ordinal()] != 1) {
            return 0;
        }
        int r = this.energyStorage.extractEnergy(amount, simulate);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return r;
    }

    @Override
    public int getEnergyStored(ForgeDirection fd) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection fd) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public int receiveEnergy(ForgeDirection fd, int amount, boolean simulate) {
        if (this.field_145850_b.field_72995_K || fd.ordinal() >= this.sideConfig.length || this.sideConfig[fd.ordinal()] != 0) {
            return 0;
        }
        int r = this.energyStorage.receiveEnergy(amount, simulate);
        return r;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (hammer && Config.getBoolean("colourblindSupport")) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_72310_e)];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, ForgeDirection.OPPOSITES[mop.field_72310_e])];
            return new String[]{StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.info.blockSide.facing") + ": " + StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.blockSide.connectEnergy." + i)), StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.info.blockSide.opposite") + ": " + StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.blockSide.connectEnergy." + j))};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, MovingObjectPosition mop) {
        return false;
    }
}

