/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelIEObj;
import blusunrize.immersiveengineering.client.render.TileRenderIE;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.model.obj.Vertex;
import org.lwjgl.opengl.GL11;

public class TileRenderCrusher
extends TileRenderIE {
    ModelIEObj model = new ModelIEObj("immersiveengineering:models/crusher.obj"){

        @Override
        public IIcon getBlockIcon(String groupName) {
            return IEContent.blockMetalMultiblocks.func_149691_a(0, 5);
        }
    };

    @Override
    public void renderStatic(TileEntity tile, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix) {
        TileEntityCrusher crusher = (TileEntityCrusher)tile;
        translationMatrix.translate(0.5, 1.5, 0.5);
        rotationMatrix.rotate(Math.toRadians(crusher.facing == 2 ? 180.0 : (crusher.facing == 4 ? -90.0 : (crusher.facing == 5 ? 90.0 : 0.0))), 0.0, 1.0, 0.0);
        if (crusher.mirrored) {
            translationMatrix.scale(new Vertex(crusher.facing < 4 ? -1.0f : 1.0f, 1.0f, crusher.facing > 3 ? -1.0f : 1.0f));
        }
        this.model.render(tile, tes, translationMatrix, rotationMatrix, 0, crusher.mirrored, "base");
    }

    @Override
    public void renderDynamic(TileEntity tile, double x, double y, double z, float f) {
        TileEntityCrusher crusher = (TileEntityCrusher)tile;
        if (!crusher.formed || crusher.pos != 17) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GL11.glRotatef((float)(crusher.facing == 2 ? 180.0f : (crusher.facing == 4 ? -90.0f : (crusher.facing == 5 ? 90.0f : 0.0f))), (float)0.0f, (float)1.0f, (float)0.0f);
        if (crusher.mirrored) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2884);
        }
        ClientUtils.bindAtlas(0);
        boolean b = crusher.hasPower && (crusher.active && crusher.process > 0 || crusher.mobGrinding || crusher.grindingTimer > 0);
        float angle = crusher.barrelRotation + (b ? 18.0f * f : 0.0f);
        GL11.glTranslated((double)1.0625, (double)0.875, (double)-0.53125);
        GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        this.model.model.renderOnly(new String[]{"drum1"});
        GL11.glRotatef((float)(-angle), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0625);
        GL11.glRotatef((float)(-angle), (float)1.0f, (float)0.0f, (float)0.0f);
        this.model.model.renderOnly(new String[]{"drum0"});
        if (crusher.mirrored) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2884);
        }
        GL11.glPopMatrix();
    }
}

