/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelIEObj;
import blusunrize.immersiveengineering.client.render.TileRenderIE;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.model.obj.Vertex;
import org.lwjgl.opengl.GL11;

public class TileRenderArcFurnace
extends TileRenderIE {
    ModelIEObj model0 = new ModelIEObj("immersiveengineering:models/arcFurnace.obj"){

        @Override
        public IIcon getBlockIcon(String groupName) {
            return IEContent.blockMetalMultiblocks.func_149691_a(0, 8);
        }
    };
    public static IIcon hotMetal_flow;
    public static IIcon hotMetal_still;

    @Override
    public void renderStatic(TileEntity tile, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix) {
        TileEntityArcFurnace arc = (TileEntityArcFurnace)tile;
        translationMatrix.translate(0.5, 0.5, 0.5);
        rotationMatrix.rotate(Math.toRadians(arc.facing == 2 ? 180.0 : (arc.facing == 4 ? -90.0 : (arc.facing == 5 ? 90.0 : 0.0))), 0.0, 1.0, 0.0);
        if (arc.mirrored) {
            translationMatrix.scale(new Vertex(arc.facing < 4 ? -1.0f : 1.0f, 1.0f, arc.facing > 3 ? -1.0f : 1.0f));
        }
        String[] render = new String[5];
        render[0] = "base";
        render[1] = "furnace";
        for (int i = 0; i < 3; ++i) {
            render[2 + i] = arc.electrodes[i] ? "electrode" + (i + 1) : "";
        }
        this.model0.render(tile, tes, translationMatrix, rotationMatrix, 0, arc.mirrored, render);
    }

    @Override
    public void renderDynamic(TileEntity tile, double x, double y, double z, float f) {
        TileEntityArcFurnace arc = (TileEntityArcFurnace)tile;
        if (!arc.formed || arc.pos != 62) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotatef((float)(arc.facing == 2 ? 180.0f : (arc.facing == 4 ? -90.0f : (arc.facing == 5 ? 90.0f : 0.0f))), (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tes = ClientUtils.tes();
        if (arc.active) {
            Matrix4 translationMatrix = new Matrix4();
            translationMatrix.scale(new Vertex(arc.mirrored ? -1.001f : 1.001f, 1.0f, 1.001f));
            translationMatrix.translate(0.0, 0.0, 2.0E-4f);
            ClientUtils.bindAtlas(0);
            tes.func_78382_b();
            tes.func_78380_c(0xF000F0);
            this.model0.render(tile, tes, translationMatrix, new Matrix4(), -1, arc.mirrored, "active");
            tes.func_78381_a();
        }
        if (arc.pouringMetal > 0) {
            int process = 40;
            float speed = 5.0f;
            int pour = process - arc.pouringMetal;
            GL11.glDisable((int)2896);
            ClientUtils.bindAtlas(0);
            float h = ((float)pour > (float)process - speed ? (float)(process - pour) / speed * 27.0f : ((float)pour > speed ? 27.0f : (float)pour / speed * 27.0f)) / 16.0f;
            tes.func_78372_c(-0.5f, -0.6875f, 1.5f);
            tes.func_78382_b();
            tes.func_78380_c(0xF000F0);
            if ((float)pour > (float)process - speed) {
                tes.func_78372_c(0.0f, -1.6875f + h, 0.0f);
            }
            if (h > 1.0f) {
                tes.func_78372_c(0.0f, -h, 0.0f);
                ClientUtils.tessellateBox(0.375, 0.0, 0.375, 0.625, 1.0, 0.625, hotMetal_flow);
                tes.func_78372_c(0.0f, 1.0f, 0.0f);
                ClientUtils.tessellateBox(0.375, 0.0, 0.375, 0.625, h - 1.0f, 0.625, hotMetal_flow);
                tes.func_78372_c(0.0f, -1.0f, 0.0f);
                tes.func_78372_c(0.0f, h, 0.0f);
            } else {
                tes.func_78372_c(0.0f, -h, 0.0f);
                ClientUtils.tessellateBox(0.375, 0.0, 0.375, 0.625, h, 0.625, hotMetal_flow);
                tes.func_78372_c(0.0f, h, 0.0f);
            }
            if ((float)pour > (float)process - speed) {
                tes.func_78372_c(0.0f, 1.6875f - h, 0.0f);
            }
            if ((float)pour > speed) {
                float h2 = (float)pour > (float)process - speed ? 0.625f : (float)pour / ((float)process - speed) * 0.625f;
                tes.func_78372_c(0.0f, -1.6875f, 0.0f);
                ClientUtils.tessellateBox(0.125, 0.0, 0.125, 0.875, h2, 0.875, hotMetal_still);
                tes.func_78372_c(0.0f, 1.6875f, 0.0f);
            }
            tes.func_78381_a();
            tes.func_78372_c(0.5f, 0.6875f, -1.5f);
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }
}

