/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiFermenter;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class NEIFermenterHandler
extends TemplateRecipeHandler {
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFermenter.class;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 12, 30, 14), "ieFermenter", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 44, 30, 14), "ieFermenter", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        Fluid ff = null;
        if (outputId == "liquid" && results != null && results.length > 0 && results[0] instanceof FluidStack) {
            ff = ((FluidStack)results[0]).getFluid();
        }
        if (outputId == "item" && results != null && results.length > 0 && results[0] instanceof ItemStack && FluidContainerRegistry.isFilledContainer((ItemStack)((ItemStack)results[0]))) {
            ff = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((ItemStack)results[0])).getFluid();
        }
        for (DieselHandler.FermenterRecipe r : DieselHandler.fermenterList) {
            if (r == null) continue;
            if (outputId == this.getOverlayIdentifier()) {
                this.arecipes.add(new CachedFermenterRecipe(r));
                continue;
            }
            if (ff == null || r.fluid == null || r.fluid.getFluid() != ff) continue;
            this.arecipes.add(new CachedFermenterRecipe(r));
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.ImmersiveEngineering.metalMultiblock.fermenter.name");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/fluidProducer.png";
    }

    public String getOverlayIdentifier() {
        return "ieFermenter";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (DieselHandler.FermenterRecipe r : DieselHandler.fermenterList) {
                if (r == null || !Utils.stackMatchesObject(result, r.output)) continue;
                this.arecipes.add(new CachedFermenterRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        DieselHandler.FermenterRecipe r;
        if (ingredient != null && (r = DieselHandler.findFermenterRecipe(ingredient)) != null) {
            this.arecipes.add(new CachedFermenterRecipe(r));
        }
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        CachedFermenterRecipe r = (CachedFermenterRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null && r.fluid != null) {
            Point localPoint = GuiDraw.getMousePosition();
            int gl = (gui.field_146294_l - 176) / 2;
            int gt = (gui.field_146295_m - 176) / 2;
            if (localPoint.x > gl + 110 && localPoint.x <= gl + 110 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 13 && localPoint.y <= gt + 64 * (recipe % 2) + 13 + 47 && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{r.fluid}) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{r.fluid}))) {
                return true;
            }
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        CachedFermenterRecipe r = (CachedFermenterRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null && r.fluid != null) {
            Point localPoint = GuiDraw.getMousePosition();
            int gl = (gui.field_146294_l - 176) / 2;
            int gt = (gui.field_146295_m - 176) / 2;
            if (localPoint.x > gl + 110 && localPoint.x <= gl + 110 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 13 && localPoint.y <= gt + 64 * (recipe % 2) + 13 + 47 && (button == 0 ? GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{r.fluid}) : button == 1 && GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{r.fluid}))) {
                return true;
            }
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> list, int recipe) {
        CachedFermenterRecipe r = (CachedFermenterRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            Point localPoint = GuiDraw.getMousePosition();
            int gl = (gui.field_146294_l - 176) / 2;
            int gt = (gui.field_146295_m - 134) / 2;
            if (r.fluid != null && localPoint.x > gl + 110 && localPoint.x <= gl + 110 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 13 && localPoint.y <= gt + 64 * (recipe % 2) + 13 + 47) {
                list.add(r.fluid.getLocalizedName());
                list.add(r.fluid.amount + " mB");
            }
            if (localPoint.x > gl + 79 && localPoint.x <= gl + 79 + 7 && localPoint.y > gt + 64 * (recipe % 2) + 25 && localPoint.y <= gt + 64 * (recipe % 2) + 25 + 18) {
                list.add(r.time + " Ticks");
            }
        }
        return super.handleTooltip(gui, list, recipe);
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-5, (int)0, (int)0, (int)8, (int)176, (int)68);
        CachedFermenterRecipe r = (CachedFermenterRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            int h = (int)(18.0f * ((float)(this.cycleticks % r.time) / (float)r.time));
            ClientUtils.drawGradientRect(75, 26 + h, 82, 44, -2829653, -3882338);
            if (r.fluid != null) {
                int max = 12000 / r.fluid.amount;
                h = (int)Math.max(1.0f, 47.0f * ((float)(this.cycleticks / 2 % max) / (float)max));
                ClientUtils.drawRepeatedFluidIcon(r.fluid.getFluid(), 106.0f, 60 - h, 16.0f, h);
                ClientUtils.bindTexture(this.getGuiTexture());
            }
        }
        GuiDraw.drawTexturedModalRect((int)104, (int)11, (int)177, (int)31, (int)20, (int)51);
    }

    public class CachedFermenterRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        FluidStack fluid;
        public int time;

        public CachedFermenterRecipe(DieselHandler.FermenterRecipe recipe) {
            super((TemplateRecipeHandler)NEIFermenterHandler.this);
            Object in = recipe.input;
            if (in instanceof String) {
                in = OreDictionary.getOres((String)((String)in));
            }
            this.input = new PositionedStack(in, 19, 9);
            if (recipe.output != null) {
                this.output = new PositionedStack((Object)recipe.output, 86, 27);
            }
            this.fluid = recipe.fluid;
            this.time = recipe.time;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIFermenterHandler.this.cycleticks / 20, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

