/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class ExternalHeaterHandler {
    public static int defaultFurnaceEnergyCost;
    public static int defaultFurnaceSpeedupCost;
    public static HashMap<Class<? extends TileEntity>, HeatableAdapter> adapterMap;

    public static void registerHeatableAdapter(Class<? extends TileEntity> c, HeatableAdapter adapter) {
        adapterMap.put(c, adapter);
    }

    public static HeatableAdapter getHeatableAdapter(Class<? extends TileEntity> c) {
        HeatableAdapter adapter = adapterMap.get(c);
        if (adapter == null && c != TileEntity.class && c.getSuperclass() != TileEntity.class) {
            adapter = ExternalHeaterHandler.getHeatableAdapter(c.getSuperclass());
            adapterMap.put(c, adapter);
        }
        return adapter;
    }

    static {
        adapterMap = new HashMap();
    }

    public static class DefaultFurnaceAdapter
    extends HeatableAdapter<TileEntityFurnace> {
        boolean canCook(TileEntityFurnace tileEntity) {
            ItemStack input = tileEntity.func_70301_a(0);
            if (input == null) {
                return false;
            }
            ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(input);
            if (output == null) {
                return false;
            }
            ItemStack existingOutput = tileEntity.func_70301_a(2);
            if (existingOutput == null) {
                return true;
            }
            if (!existingOutput.func_77969_a(output)) {
                return false;
            }
            int stackSize = existingOutput.field_77994_a + output.field_77994_a;
            return stackSize <= tileEntity.func_70297_j_() && stackSize <= output.func_77976_d();
        }

        @Override
        public int doHeatTick(TileEntityFurnace tileEntity, int energyAvailable, boolean redstone) {
            int energyConsumed = 0;
            boolean canCook = this.canCook(tileEntity);
            if (canCook || redstone) {
                int energyToUse;
                int heatEnergyRatio;
                int heatAttempt;
                int energyToUse2;
                int heat;
                boolean burning = tileEntity.func_145950_i();
                if (tileEntity.field_145956_a < 200 && (heat = (energyToUse2 = Math.min(energyAvailable, (heatAttempt = 4) * (heatEnergyRatio = Math.max(1, defaultFurnaceEnergyCost)))) / heatEnergyRatio) > 0) {
                    tileEntity.field_145956_a += heat;
                    energyConsumed += heat * heatEnergyRatio;
                    if (!burning) {
                        this.updateFurnace((TileEntity)tileEntity, tileEntity.field_145956_a > 0);
                    }
                }
                if (canCook && tileEntity.field_145956_a >= 200 && tileEntity.field_145961_j < 199 && energyAvailable - energyConsumed > (energyToUse = defaultFurnaceSpeedupCost)) {
                    energyConsumed += energyToUse;
                    ++tileEntity.field_145961_j;
                }
            }
            return energyConsumed;
        }

        public void updateFurnace(TileEntity tileEntity, boolean active) {
            Block containing = tileEntity.func_145838_q();
            if (containing == Blocks.field_150460_al || containing == Blocks.field_150470_am) {
                BlockFurnace.func_149931_a((boolean)active, (World)tileEntity.func_145831_w(), (int)tileEntity.field_145851_c, (int)tileEntity.field_145848_d, (int)tileEntity.field_145849_e);
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                tileEntity.func_145841_b(nbt);
                nbt.func_74757_a("active", active);
                nbt.func_74757_a("Active", active);
                tileEntity.func_145839_a(nbt);
                tileEntity.func_145831_w().func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
            }
        }
    }

    public static abstract class HeatableAdapter<E extends TileEntity> {
        public abstract int doHeatTick(E var1, int var2, boolean var3);
    }

    public static interface IExternalHeatable {
        public int doHeatTick(int var1, boolean var2);
    }
}

