/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.fluid;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeConnection {
    public ChunkCoordinates from;
    public ChunkCoordinates to;
    public ForgeDirection direction;
    public Type type;

    public PipeConnection(ChunkCoordinates from, ChunkCoordinates to, ForgeDirection direction, Type type) {
        this.from = from;
        this.to = to;
        this.direction = direction;
        this.type = type;
    }

    public PipeConnection(ChunkCoordinates from, ChunkCoordinates to, Type type) {
        this(from, to, PipeConnection.toDirection(from, to), type);
    }

    public static ForgeDirection toDirection(ChunkCoordinates from, ChunkCoordinates to) {
        if (to == null || from == null) {
            return ForgeDirection.UNKNOWN;
        }
        int dX = to.field_71574_a - from.field_71574_a;
        int dY = to.field_71572_b - from.field_71572_b;
        int dZ = to.field_71573_c - from.field_71573_c;
        if (Math.abs(dX) == 1 && dY == 0 && dZ == 0) {
            return dX == 1 ? ForgeDirection.EAST : ForgeDirection.WEST;
        }
        if (dX == 0 && Math.abs(dY) == 1 && dZ == 0) {
            return dY == 1 ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        if (dX == 0 && dY == 0 && Math.abs(dZ) == 1) {
            return dZ == 1 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static PipeConnection fromNBT(NBTTagCompound compound) {
        int[] toArr = compound.func_74759_k("To");
        int[] fromArr = compound.func_74759_k("From");
        int directionOrdinal = compound.func_74762_e("Direction");
        return new PipeConnection(new ChunkCoordinates(toArr[0], toArr[1], toArr[2]), new ChunkCoordinates(fromArr[0], fromArr[1], fromArr[2]), ForgeDirection.getOrientation((int)directionOrdinal), Type.fromOrdinal(compound.func_74762_e("Type")));
    }

    public static boolean isTank(TileEntity tileEntity, ForgeDirection direction) {
        boolean isTank = tileEntity instanceof IFluidHandler;
        if (isTank) {
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity;
            FluidTankInfo[] tankInfo = fluidHandler.getTankInfo(direction);
            isTank = tankInfo != null && tankInfo.length > 0;
        }
        return isTank;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74783_a("To", new int[]{this.to.field_71574_a, this.to.field_71572_b, this.to.field_71573_c});
        compound.func_74783_a("From", new int[]{this.from.field_71574_a, this.from.field_71572_b, this.from.field_71573_c});
        compound.func_74768_a("Direction", this.direction.ordinal());
        compound.func_74768_a("Type", this.type.ordinal());
        return compound;
    }

    public TileEntity getEndTile(World world) {
        return world.func_147438_o(this.to.field_71574_a, this.to.field_71572_b, this.to.field_71573_c);
    }

    public String toString() {
        return this.from.toString() + " -> " + this.to.toString() + " in direction " + this.direction.toString();
    }

    public boolean equals(PipeConnection connection) {
        return connection.direction == this.direction && connection.to.field_71574_a == this.to.field_71574_a && connection.to.field_71572_b == this.to.field_71572_b && connection.to.field_71573_c == this.to.field_71573_c && connection.from.field_71574_a == this.from.field_71574_a && connection.from.field_71572_b == this.from.field_71572_b && connection.from.field_71573_c == this.from.field_71573_c;
    }

    public static enum Type {
        PIPE,
        TANK;

        private static Type[] TYPES;

        public static Type fromOrdinal(int type) {
            return TYPES[type];
        }

        static {
            TYPES = new Type[]{PIPE, TANK};
        }
    }
}

