/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BottlingMachineRecipe {
    public final Object input;
    public final FluidStack fluidInput;
    public final ItemStack output;
    public static ArrayList<BottlingMachineRecipe> recipeList = new ArrayList();

    public BottlingMachineRecipe(ItemStack output, Object input, FluidStack fluidInput) {
        this.output = output;
        this.input = ApiUtils.convertToValidRecipeInput(input);
        this.fluidInput = fluidInput;
    }

    public static void addRecipe(ItemStack output, Object input, FluidStack fluidInput) {
        BottlingMachineRecipe recipe = new BottlingMachineRecipe(output, input, fluidInput);
        if (recipe.input != null) {
            recipeList.add(recipe);
        }
    }

    public static BottlingMachineRecipe findRecipe(ItemStack input, FluidStack fluid) {
        if (input != null && fluid != null) {
            for (BottlingMachineRecipe recipe : recipeList) {
                if (!ApiUtils.stackMatchesObject(input, recipe.input) || !fluid.containsFluid(recipe.fluidInput)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static List<BottlingMachineRecipe> removeRecipes(ItemStack stack) {
        ArrayList<BottlingMachineRecipe> list = new ArrayList<BottlingMachineRecipe>();
        Iterator<BottlingMachineRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            BottlingMachineRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }
}

