/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale.mixin.mixins.client.minecraft;

import com.github.basdxz.rightproperguiscale.mixin.interfaces.client.minecraft.IScaledResolutionMixin;
import com.github.basdxz.rightproperguiscale.util.Util;
import lombok.NonNull;
import net.minecraft.client.gui.GuiEnchantment;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={GuiEnchantment.class})
public abstract class GuiEnchantmentBookAlignmentMixin {
    private static final int BOOK_RENDER_WIDTH = 320;
    private static final int BOOK_RENDER_HEIGHT = 240;

    @Redirect(method={"drawGuiContainerBackgroundLayer(FII)V"}, at=@At(value="INVOKE", target="org/lwjgl/opengl/GL11.glViewport (IIII)V", ordinal=0), require=1)
    private void fixBookViewport(int xPos, int yPos, int width, int height) {
        this.setBookViewport();
    }

    private void setBookViewport() {
        IScaledResolutionMixin scaledResolution = Util.newIScaledResolutionMixin();
        GL11.glViewport((int)this.bookViewportXPos(scaledResolution), (int)this.bookViewportYPos(scaledResolution), (int)this.bookViewportWidth(scaledResolution), (int)this.bookViewportHeight(scaledResolution));
    }

    private int bookViewportXPos(@NonNull IScaledResolutionMixin scaledResolution) {
        if (scaledResolution == null) {
            throw new NullPointerException("scaledResolution is marked non-null but is null");
        }
        return MathHelper.func_76143_f((double)((float)(scaledResolution.scaledWidth() - 320) / 2.0f * scaledResolution.scaleFactor()));
    }

    private int bookViewportYPos(@NonNull IScaledResolutionMixin scaledResolution) {
        if (scaledResolution == null) {
            throw new NullPointerException("scaledResolution is marked non-null but is null");
        }
        return MathHelper.func_76143_f((double)((float)(scaledResolution.scaledHeight() - 240) / 2.0f * scaledResolution.scaleFactor()));
    }

    private int bookViewportWidth(@NonNull IScaledResolutionMixin scaledResolution) {
        if (scaledResolution == null) {
            throw new NullPointerException("scaledResolution is marked non-null but is null");
        }
        return MathHelper.func_76123_f((float)(320.0f * scaledResolution.scaleFactor()));
    }

    private int bookViewportHeight(@NonNull IScaledResolutionMixin scaledResolution) {
        if (scaledResolution == null) {
            throw new NullPointerException("scaledResolution is marked non-null but is null");
        }
        return MathHelper.func_76123_f((float)(240.0f * scaledResolution.scaleFactor()));
    }
}

