/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale.mixin.mixins.client.minecraft;

import com.github.basdxz.rightproperguiscale.GUIScale;
import com.github.basdxz.rightproperguiscale.util.Util;
import lombok.NonNull;
import net.minecraft.client.settings.GameSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameSettings.class})
public abstract class GameSettingGUIScaleSliderMixin {
    @Shadow
    public int field_74335_Z;

    @Inject(method={"getKeyBinding(Lnet/minecraft/client/settings/GameSettings$Options;)Ljava/lang/String;"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void guiScaleLabel(GameSettings.Options option, CallbackInfoReturnable<String> cir) {
        if (Util.isGUIScaleOption(option)) {
            this.returnGUIScaleSliderLabel(cir);
        }
    }

    private void returnGUIScaleSliderLabel(@NonNull CallbackInfoReturnable<String> cir) {
        if (cir == null) {
            throw new NullPointerException("cir is marked non-null but is null");
        }
        cir.setReturnValue((Object)GUIScale.sliderLabel());
        cir.cancel();
    }

    @Inject(method={"setOptionFloatValue(Lnet/minecraft/client/settings/GameSettings$Options;F)V"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void setGuiScaleValue(GameSettings.Options option, float value, CallbackInfo ci) {
        if (Util.isGUIScaleOption(option)) {
            this.setTempGUIScale(value, ci);
        }
    }

    private void setTempGUIScale(float guiScale, @NonNull CallbackInfo ci) {
        if (ci == null) {
            throw new NullPointerException("ci is marked non-null but is null");
        }
        GUIScale.setTemp(guiScale);
        ci.cancel();
    }

    @Inject(method={"getOptionFloatValue(Lnet/minecraft/client/settings/GameSettings$Options;)F"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void getGuiScaleValue(GameSettings.Options option, CallbackInfoReturnable<Float> cir) {
        if (Util.isGUIScaleOption(option)) {
            this.returnGUIScale(cir);
        }
    }

    private void returnGUIScale(@NonNull CallbackInfoReturnable<Float> cir) {
        if (cir == null) {
            throw new NullPointerException("cir is marked non-null but is null");
        }
        cir.setReturnValue((Object)Float.valueOf(GUIScale.value()));
        cir.cancel();
    }
}

