/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale.command;

import com.github.basdxz.rightproperguiscale.GUIScale;
import java.util.Optional;
import lombok.NonNull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;

public class GUIScaleCommand
extends CommandBase {
    protected static final GUIScaleCommand INSTANCE = new GUIScaleCommand();
    protected static final String GUI_SCALE_COMMAND_NAME = "guiscale";
    protected static final String GUI_SCALE_COMMAND_USE_UNLOCALIZED = "commands.guiscale.usage";
    protected static final String GUI_SCALE_COMMAND_SUCCESS_UNLOCALIZED = "commands.guiscale.success";
    protected static final String GUI_SCALE_COMMAND_NUMBER_INVALID = "commands.guiscale.number_invalid";
    protected static final int GUI_SCALE_ARGUMENT_INDEX = 0;
    protected static final int GUI_SCALE_COMMAND_ARGUMENT_COUNT = 1;

    public static void register() {
        ClientCommandHandler.instance.func_71560_a((ICommand)INSTANCE);
    }

    public String func_71517_b() {
        return GUI_SCALE_COMMAND_NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        return GUI_SCALE_COMMAND_USE_UNLOCALIZED;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (this.argsNull(sender, args) || this.argsWrongCount(args)) {
            throw this.newWrongUsageException();
        }
        Optional<Float> guiScale = this.parseGUIScale(args);
        if (!guiScale.isPresent()) {
            throw this.newNumberInvalidGUIScaleValueException(args);
        }
        this.updateGUIScale(guiScale.get().floatValue());
        this.sendSuccessMessage(sender);
    }

    protected boolean argsNull(ICommandSender sender, String[] args) {
        return sender == null || args == null;
    }

    protected boolean argsWrongCount(@NonNull String[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return args.length != 1;
    }

    protected CommandException newWrongUsageException() {
        return new WrongUsageException(GUI_SCALE_COMMAND_USE_UNLOCALIZED, new Object[0]);
    }

    protected Optional<Float> parseGUIScale(@NonNull String[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        try {
            return Optional.of(Float.valueOf(Float.parseFloat(args[0])));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    protected CommandException newNumberInvalidGUIScaleValueException(@NonNull String[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return new NumberInvalidException(GUI_SCALE_COMMAND_NUMBER_INVALID, new Object[]{args[0]});
    }

    protected void updateGUIScale(float guiScale) {
        GUIScale.set(guiScale);
        GUIScale.save();
    }

    protected void sendSuccessMessage(@NonNull ICommandSender sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        sender.func_145747_a(this.newSuccessMessage());
    }

    protected IChatComponent newSuccessMessage() {
        return new ChatComponentTranslation(GUI_SCALE_COMMAND_SUCCESS_UNLOCALIZED, new Object[]{Float.valueOf(GUIScale.value())});
    }

    protected GUIScaleCommand() {
    }
}

