/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale;

import com.github.basdxz.rightproperguiscale.command.GUIScaleCommand;
import com.github.basdxz.rightproperguiscale.config.RightProperGUIScaleConfig;
import com.github.basdxz.rightproperguiscale.mixin.interfaces.client.minecraft.IScaledResolutionMixin;
import com.github.basdxz.rightproperguiscale.reflection.GameSettingReflections;
import com.github.basdxz.rightproperguiscale.util.Util;
import java.text.DecimalFormat;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.MathHelper;

public final class GUIScale {
    private static final int VANILLA_SMALL_GUI_SCALE = 1;
    private static final int VANILLA_NORMAL_GUI_SCALE = 2;
    private static final int VANILLA_LARGE_GUI_SCALE = 3;
    private static final int VANILLA_AUTO_GUI_SCALE = 0;
    private static final DecimalFormat FLOAT_FORMAT = new DecimalFormat();
    private static boolean IS_INITIALIZED = false;
    private static float VALUE = (float)RightProperGUIScaleConfig.GUI_SCALE_DEFAULT;
    private static int VALUE_INT = GUIScale.defaultIntValue();
    private static float TEMP = VALUE;
    private static IScaledResolutionMixin LAST_SCALED_RESOLUTION;

    private static int defaultIntValue() {
        return GUIScale.vanillaGuiScaleSetting((float)RightProperGUIScaleConfig.GUI_SCALE_DEFAULT);
    }

    public static void init() {
        if (IS_INITIALIZED) {
            return;
        }
        GameSettingReflections.apply();
        GUIScaleCommand.register();
        IS_INITIALIZED = true;
    }

    public static float value() {
        return VALUE;
    }

    public static int vanillaValue() {
        return VALUE_INT;
    }

    public static void configure() {
        GameSettingReflections.apply();
        GUIScale.reapplyLimits();
    }

    private static void reapplyLimits() {
        GUIScale.set(VALUE);
    }

    public static String sliderLabel() {
        return I18n.func_135052_a((String)GameSettings.Options.GUI_SCALE.func_74378_d(), (Object[])new Object[0]) + ": " + GUIScale.formattedSliderValues();
    }

    private static String formattedSliderValues() {
        GUIScale.updateFloatFormat();
        return String.format("%sx (%sx)", FLOAT_FORMAT.format(TEMP), FLOAT_FORMAT.format(LAST_SCALED_RESOLUTION.scaleFactor()));
    }

    private static void updateFloatFormat() {
        int fractionDigits = GUIScale.fractionDigits();
        FLOAT_FORMAT.setMaximumFractionDigits(fractionDigits);
        FLOAT_FORMAT.setMinimumFractionDigits(fractionDigits);
    }

    private static int fractionDigits() {
        return Math.round((float)(-Math.log10(RightProperGUIScaleConfig.GUI_SCALE_STEP)));
    }

    public static void set(float guiScale) {
        GUIScale.setTemp(guiScale);
        GUIScale.update();
    }

    public static void setTemp(float guiScale) {
        TEMP = GUIScale.clampGUIScale(guiScale);
    }

    private static float clampGUIScale(float guiScale) {
        return (float)Math.max(Math.min((double)guiScale, RightProperGUIScaleConfig.GUI_SCALE_MAX), RightProperGUIScaleConfig.GUI_SCALE_MIN);
    }

    public static void update() {
        GUIScale.pushTemp();
        GUIScale.updateMinecraft();
        GUIScale.updateCurrentGUI();
    }

    private static void pushTemp() {
        VALUE = TEMP;
        VALUE_INT = GUIScale.vanillaGuiScaleSetting(TEMP);
    }

    private static int vanillaGuiScaleSetting(float guiScale) {
        if (guiScale < 1.0f) {
            return 1;
        }
        if (guiScale <= 3.0f) {
            return MathHelper.func_76123_f((float)VALUE);
        }
        return 0;
    }

    private static void updateMinecraft() {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (settings != null) {
            settings.field_74335_Z = VALUE_INT;
        }
    }

    private static void updateCurrentGUI() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen == null) {
            return;
        }
        ScaledResolution scaledResolution = Util.newScaledResolution();
        screen.func_146280_a(Minecraft.func_71410_x(), scaledResolution.func_78326_a(), scaledResolution.func_78328_b());
    }

    public static void lastScaledResolution(@NonNull IScaledResolutionMixin scaledResolution) {
        if (scaledResolution == null) {
            throw new NullPointerException("scaledResolution is marked non-null but is null");
        }
        LAST_SCALED_RESOLUTION = scaledResolution;
    }

    public static void save() {
        Minecraft.func_71410_x().field_71474_y.func_74303_b();
    }

    private GUIScale() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

