/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.search;

import codechicken.nei.ItemList;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.guihook.GuiContainerManager;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class TooltipFilter
implements ItemFilter {
    private static final ConcurrentHashMap<ItemStackKey, String> itemSearchNames = new ConcurrentHashMap();
    private final Pattern pattern;

    public TooltipFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matches(ItemStack itemStack) {
        return this.pattern.matcher(TooltipFilter.getSearchTooltip(itemStack)).find();
    }

    public static void populateSearchMap() {
        new Thread("NEI populate Tooltip Filter"){

            @Override
            public void run() {
                ItemList.items.parallelStream().forEach(TooltipFilter::getSearchTooltip);
            }
        }.start();
    }

    protected static String getSearchTooltip(ItemStack stack) {
        return itemSearchNames.computeIfAbsent(new ItemStackKey(stack), key -> TooltipFilter.getTooltip(key.stack));
    }

    private static String getTooltip(ItemStack itemstack) {
        List<String> list = GuiContainerManager.itemDisplayNameMultiline(itemstack, null, true);
        return EnumChatFormatting.func_110646_a((String)String.join((CharSequence)"\n", list.subList(1, list.size())));
    }

    private static class ItemStackKey {
        public final ItemStack stack;

        public ItemStackKey(ItemStack stack) {
            this.stack = stack;
        }

        public int hashCode() {
            if (this.stack == null) {
                return 1;
            }
            int hashCode = 1;
            hashCode = 31 * hashCode + this.stack.field_77994_a;
            hashCode = 31 * hashCode + Item.func_150891_b((Item)this.stack.func_77973_b());
            hashCode = 31 * hashCode + this.stack.func_77960_j();
            hashCode = 31 * hashCode + (!this.stack.func_77942_o() ? 0 : this.stack.func_77978_p().hashCode());
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemStackKey)) {
                return false;
            }
            return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)((ItemStackKey)o).stack);
        }
    }
}

