/*
 * Decompiled with CFR 0.152.
 */
package assets.rivalrebels.common.explosion;

import assets.rivalrebels.RivalRebels;
import assets.rivalrebels.common.entity.EntityAntimatterBombBlast;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class AntimatterBomb {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public World worldObj;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;
    private int repeatCount = 0;
    private boolean isTree;
    private int treeHeight;
    public int processedchunks = 0;

    public AntimatterBomb(int x, int y, int z, World world, int rad) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.worldObj = world;
        this.radius = rad;
        this.nlimit = (this.radius + 25) * (this.radius + 25) * 4;
        rad = rad * rad / 2;
        if (world.field_72995_K) {
            return;
        }
        System.out.println("radius:" + this.radius);
        System.out.println("Nlimit:" + this.nlimit);
        int clamprad = this.radius;
        for (int X = -clamprad; X < clamprad; ++X) {
            int x2 = X * X;
            for (int Z = -clamprad; Z < clamprad; ++Z) {
                if (x2 + Z * Z >= rad) continue;
                for (int Y = 70; Y > 0; --Y) {
                    Block block = this.worldObj.func_147439_a(X + this.posX, Y, Z + this.posZ);
                    if (block != Blocks.field_150355_j && block != Blocks.field_150353_l && block != Blocks.field_150358_i && block != Blocks.field_150356_k) continue;
                    this.worldObj.func_147468_f(X + this.posX, Y, Z + this.posZ);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(EntityAntimatterBombBlast tsarblast) {
        if (this.n > 0 && this.n < this.nlimit) {
            boolean repeat = this.processChunk(this.lastposX, this.lastposZ);
            this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
            int shell2 = 2 * this.shell;
            this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
            this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
            int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
            this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
            ++this.n;
            if (repeat) return;
            ++this.repeatCount;
            if (this.repeatCount < RivalRebels.tsarBombaSpeed * 2) {
                this.update(tsarblast);
                return;
            }
            this.repeatCount = 0;
            return;
        }
        tsarblast.tsar = null;
        tsarblast.func_70106_y();
    }

    private boolean processChunk(int x, int z) {
        ++this.processedchunks;
        double dist = x * x + z * z;
        if (dist < (double)(this.radius * this.radius)) {
            dist = Math.sqrt(dist);
            int y = this.getTopBlock(x + this.posX, z + this.posZ, dist);
            float yele = (float)this.posY + (float)(y - this.posY) * 0.5f;
            if (RivalRebels.elevation) {
                yele = y;
            }
            int ylimit = (int)Math.floor((double)yele - ((double)this.radius - dist) * 4.0);
            for (int Y = y; Y > ylimit && Y != 0; --Y) {
                Block block = this.worldObj.func_147439_a(x + this.posX, Y, z + this.posZ);
                if (block == RivalRebels.omegaobj) {
                    RivalRebels.round.winSigma();
                } else if (block == RivalRebels.sigmaobj) {
                    RivalRebels.round.winOmega();
                }
                this.worldObj.func_147449_b(x + this.posX, Y, z + this.posZ, Blocks.field_150350_a);
            }
            double limit = (double)(this.radius / 2 + this.worldObj.field_73012_v.nextInt(this.radius / 4)) + 7.5;
            if (dist < limit) {
                for (int Y = ylimit; Y > ylimit - (this.worldObj.field_73012_v.nextInt(5) + 2) && Y != 0; --Y) {
                    Block block = this.worldObj.func_147439_a(x + this.posX, Y, z + this.posZ);
                    if (block == RivalRebels.omegaobj) {
                        RivalRebels.round.winSigma();
                    } else if (block == RivalRebels.sigmaobj) {
                        RivalRebels.round.winOmega();
                    }
                    this.worldObj.func_147449_b(x + this.posX, Y, z + this.posZ, Blocks.field_150343_Z);
                }
            }
            return true;
        }
        if (dist <= (double)(this.radius * this.radius) * 1.3125 * 1.3125) {
            dist = Math.sqrt(dist);
            int y = this.getTopBlock(x + this.posX, z + this.posZ, dist);
            int ylimit = (int)Math.ceil(Math.sin((dist - (double)this.radius - (double)(this.radius / 16)) * (double)this.radius * 0.001875) * (double)(this.radius / 16));
            if (dist >= (double)(this.radius + 5)) {
                int metadata = (int)Math.floor(16.0 / (double)this.radius * dist);
                if (metadata < 0) {
                    metadata = 0;
                }
                if (++metadata > 15) {
                    metadata = 15;
                }
                for (int Y = ylimit; Y >= 0; --Y) {
                    if (Y == 0) continue;
                    int yy = Y + y;
                    Block blockID = this.worldObj.func_147439_a(x + this.posX, yy, z + this.posZ);
                    if (blockID == RivalRebels.omegaobj) {
                        RivalRebels.round.winSigma();
                        continue;
                    }
                    if (blockID == RivalRebels.sigmaobj) {
                        RivalRebels.round.winOmega();
                        continue;
                    }
                    if (!this.isTree) {
                        Block blockID1 = this.worldObj.func_147439_a(x + this.posX, yy - ylimit, z + this.posZ);
                        int datavalue = this.worldObj.func_72805_g(x + this.posX, yy - ylimit, z + this.posZ);
                        this.worldObj.func_147465_d(x + this.posX, yy, z + this.posZ, blockID1, datavalue, 3);
                        continue;
                    }
                    this.isTree = false;
                    for (int Yy = 0; Yy >= -this.treeHeight; --Yy) {
                        this.worldObj.func_147449_b(x + this.posX, yy + Yy, z + this.posZ, RivalRebels.petrifiedwood);
                        this.worldObj.func_72921_c(x + this.posX, yy + Yy, z + this.posZ, metadata, 3);
                    }
                    break;
                }
            } else {
                Block blockID = this.worldObj.func_147439_a(x + this.posX, y, z + this.posZ);
                if (blockID != null && !blockID.func_149662_c()) {
                    this.worldObj.func_147449_b(x + this.posX, y, z + this.posZ, Blocks.field_150350_a);
                }
            }
            return true;
        }
        return false;
    }

    private int getTopBlock(int x, int z, double dist) {
        int foundY = 0;
        boolean found = false;
        for (int y = 256; y > 0; --y) {
            Block blockID = this.worldObj.func_147439_a(x, y, z);
            if (blockID == Blocks.field_150350_a) continue;
            if (blockID == RivalRebels.omegaobj) {
                RivalRebels.round.winSigma();
            } else if (blockID == RivalRebels.sigmaobj) {
                RivalRebels.round.winOmega();
            }
            if (blockID == RivalRebels.reactive) {
                int i = 0;
                while ((double)i < (1.0 - dist / (double)this.radius) * 16.0 + Math.random() * 2.0) {
                    this.worldObj.func_147449_b(x, y, z, Blocks.field_150350_a);
                    ++i;
                }
            }
            if (!blockID.func_149662_c() || blockID == Blocks.field_150364_r) {
                this.worldObj.func_147468_f(x, y, z);
                if (dist > (double)(this.radius / 2) && blockID == Blocks.field_150364_r && this.worldObj.func_147439_a(x, y - 1, z) == Blocks.field_150364_r) {
                    this.isTree = true;
                }
                if (found || !this.isTree) continue;
                foundY = y;
                found = true;
                continue;
            }
            if (!found) {
                return y;
            }
            this.treeHeight = foundY - y;
            return foundY;
        }
        return foundY;
    }
}

