/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class StripesHandlerEntityInteract
implements IStripesHandler {
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    public boolean shouldHandle(ItemStack stack) {
        return true;
    }

    public boolean handle(World world, int x, int y, int z, ForgeDirection direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        List entities = world.func_72839_b(null, box);
        if (entities.size() <= 0) {
            return false;
        }
        LinkedList<EntityLivingBase> livingEntities = new LinkedList<EntityLivingBase>();
        for (Object entityObj : entities) {
            if (!(entityObj instanceof EntityLivingBase)) continue;
            livingEntities.add((EntityLivingBase)entityObj);
        }
        player.func_70062_b(0, stack);
        boolean successful = false;
        Collections.shuffle(livingEntities);
        while (livingEntities.size() > 0) {
            EntityLivingBase entity = (EntityLivingBase)livingEntities.remove(0);
            if (!player.func_70998_m((Entity)entity)) continue;
            successful = true;
            this.dropItemsExcept(stack, player, activator, direction);
        }
        if (stack.field_77994_a > 0 && successful) {
            activator.sendItem(stack, direction.getOpposite());
        }
        player.func_70062_b(0, null);
        return successful;
    }

    private void dropItemsExcept(ItemStack stack, EntityPlayer player, IStripesActivator activator, ForgeDirection direction) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            if (invStack == null || invStack == stack) continue;
            player.field_71071_by.func_70299_a(i, null);
            activator.sendItem(invStack, direction.getOpposite());
        }
    }
}

