/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.transport.Pipe;
import buildcraft.transport.statements.TriggerParameterSignal;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;

public class TriggerPipeSignal
extends BCStatement
implements ITriggerInternal {
    boolean active;
    PipeWire color;

    public TriggerPipeSignal(boolean active, PipeWire color) {
        super(new String[]{"buildcraft:pipe.wire.input." + color.name().toLowerCase(Locale.ENGLISH) + (active ? ".active" : ".inactive"), "buildcraft.pipe.wire.input." + color.name().toLowerCase(Locale.ENGLISH) + (active ? ".active" : ".inactive")});
        this.active = active;
        this.color = color;
    }

    public int maxParameters() {
        return 3;
    }

    public String getDescription() {
        return String.format(StringUtils.localize((String)("gate.trigger.pipe.wire." + (this.active ? "active" : "inactive"))), StringUtils.localize((String)("color." + this.color.name().toLowerCase(Locale.ENGLISH))));
    }

    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container instanceof IGate)) {
            return false;
        }
        Pipe pipe = (Pipe)((IGate)container).getPipe();
        if (this.active ? pipe.wireSignalStrength[this.color.ordinal()] == 0 : pipe.wireSignalStrength[this.color.ordinal()] > 0) {
            return false;
        }
        for (IStatementParameter param : parameters) {
            if (param == null || !(param instanceof TriggerParameterSignal)) continue;
            TriggerParameterSignal signal = (TriggerParameterSignal)param;
            if (signal.color == null || !(signal.active ? pipe.wireSignalStrength[signal.color.ordinal()] == 0 : pipe.wireSignalStrength[signal.color.ordinal()] > 0)) continue;
            return false;
        }
        return true;
    }

    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("buildcrafttransport:triggers/trigger_pipesignal_" + this.color.name().toLowerCase() + "_" + (this.active ? "active" : "inactive"));
    }

    public IStatementParameter createParameter(int index) {
        return new TriggerParameterSignal();
    }
}

