/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TravelingItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TriggerPipeContents
extends BCStatement
implements ITriggerInternal {
    private PipeContents kind;

    public TriggerPipeContents(PipeContents kind) {
        super(new String[]{"buildcraft:pipe.contents." + kind.name().toLowerCase(Locale.ENGLISH), "buildcraft.pipe.contents." + kind.name()});
        this.kind = kind;
        kind.trigger = this;
    }

    public int maxParameters() {
        switch (this.kind) {
            case containsItems: 
            case containsFluids: {
                return 1;
            }
        }
        return 0;
    }

    public String getDescription() {
        return StringUtils.localize((String)("gate.trigger.pipe." + this.kind.name()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container instanceof IGate)) {
            return false;
        }
        Pipe pipe = (Pipe)((IGate)container).getPipe();
        IStatementParameter parameter = parameters[0];
        if (pipe.transport instanceof PipeTransportItems) {
            PipeTransportItems transportItems = (PipeTransportItems)pipe.transport;
            if (this.kind == PipeContents.empty) {
                return transportItems.items.isEmpty();
            }
            if (this.kind != PipeContents.containsItems) return false;
            if (parameter != null && parameter.getItemStack() != null) {
                TravelingItem item;
                Iterator<TravelingItem> iterator = transportItems.items.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    item = iterator.next();
                } while (!StackHelper.isMatchingItemOrList((ItemStack)parameter.getItemStack(), (ItemStack)item.getItemStack()));
                return true;
            }
            if (transportItems.items.isEmpty()) return false;
            return true;
        }
        if (pipe.transport instanceof PipeTransportFluids) {
            PipeTransportFluids transportFluids = (PipeTransportFluids)pipe.transport;
            if (this.kind == PipeContents.empty) {
                if (transportFluids.fluidType != null) return false;
                return true;
            }
            if (parameter != null && parameter.getItemStack() != null) {
                FluidStack searchedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)parameter.getItemStack());
                if (searchedFluid == null) return false;
                if (transportFluids.fluidType == null) return false;
                if (!searchedFluid.isFluidEqual(transportFluids.fluidType)) return false;
                return true;
            }
            if (transportFluids.fluidType == null) return false;
            return true;
        }
        if (!(pipe.transport instanceof PipeTransportPower)) return false;
        PipeTransportPower transportPower = (PipeTransportPower)pipe.transport;
        switch (this.kind) {
            case empty: {
                short[] sArray = transportPower.displayPower;
                int n = sArray.length;
                int n2 = 0;
                while (n2 < n) {
                    short s = sArray[n2];
                    if (s > 0) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            case containsEnergy: {
                short[] sArray = transportPower.displayPower;
                int n = sArray.length;
                int n3 = 0;
                while (n3 < n) {
                    short s = sArray[n3];
                    if (s > 0) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            case requestsEnergy: {
                return transportPower.isQueryingPower();
            }
        }
        return transportPower.isOverloaded();
    }

    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcrafttransport:triggers/trigger_pipecontents_" + this.kind.name().toLowerCase(Locale.ENGLISH));
    }

    public static enum PipeContents {
        empty,
        containsItems,
        containsFluids,
        containsEnergy,
        requestsEnergy,
        tooMuchEnergy;

        public ITriggerInternal trigger;
    }
}

