/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.core.Position;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.containers.ISidedStatementContainer;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;

public class TriggerLightSensor
extends BCStatement
implements ITriggerInternal {
    private final boolean bright;

    public TriggerLightSensor(boolean bright) {
        super(new String[]{"buildcraft:light_" + (bright ? "bright" : "dark")});
        this.bright = bright;
    }

    public String getDescription() {
        return StringUtils.localize((String)("gate.trigger.light." + (this.bright ? "bright" : "dark")));
    }

    public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
        TileEntity tile = source.getTile();
        Position pos = new Position(tile);
        pos.orientation = ((ISidedStatementContainer)source).getSide();
        pos.moveForwards(1.0);
        int lightLevel = tile.func_145831_w().func_72957_l((int)pos.x, (int)pos.y, (int)pos.z);
        return lightLevel < 8 ^ this.bright;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcrafttransport:triggers/trigger_light_" + (this.bright ? "bright" : "dark"));
    }
}

