/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.transport.Gate;
import buildcraft.transport.statements.ActionParameterSignal;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;

public class ActionSignalOutput
extends BCStatement
implements IActionInternal {
    public final PipeWire color;

    public ActionSignalOutput(PipeWire color) {
        super(new String[]{"buildcraft:pipe.wire.output." + color.name().toLowerCase(Locale.ENGLISH), "buildcraft.pipe.wire.output." + color.name().toLowerCase(Locale.ENGLISH)});
        this.color = color;
    }

    public String getDescription() {
        return String.format(StringUtils.localize((String)"gate.action.pipe.wire"), StringUtils.localize((String)("color." + this.color.name().toLowerCase(Locale.ENGLISH))));
    }

    public int maxParameters() {
        return 3;
    }

    public IStatementParameter createParameter(int index) {
        return new ActionParameterSignal();
    }

    public void actionActivate(IStatementContainer container, IStatementParameter[] parameters) {
        Gate gate = (Gate)container;
        gate.broadcastSignal(this.color);
        for (IStatementParameter param : parameters) {
            if (param == null || !(param instanceof ActionParameterSignal)) continue;
            ActionParameterSignal signal = (ActionParameterSignal)param;
            if (signal.color == null) continue;
            gate.broadcastSignal(signal.color);
        }
    }

    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("buildcrafttransport:triggers/trigger_pipesignal_" + this.color.name().toLowerCase() + "_active");
    }
}

