/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.Position;
import buildcraft.api.items.IItemCustomPipeRender;
import buildcraft.core.lib.render.RenderEntityBlock;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.render.PipeTransportRenderer;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class PipeTransportItemsRenderer
extends PipeTransportRenderer<PipeTransportItems> {
    private static final EntityItem dummyEntityItem = new EntityItem(null);
    private static final RenderItem customRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };
    private static final int MAX_ITEMS_TO_RENDER = 10;

    private int getItemLightLevel(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block b = Block.func_149634_a((Item)stack.func_77973_b());
            return b.func_149750_m();
        }
        return 0;
    }

    public void doRenderItem(TravelingItem travellingItem, double x, double y, double z, float light, EnumColor color) {
        if (travellingItem == null || travellingItem.getItemStack() == null) {
            return;
        }
        float renderScale = 0.7f;
        ItemStack itemstack = travellingItem.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.25f), (float)((float)z));
        GL11.glEnable((int)3008);
        if (travellingItem.hasDisplayList) {
            GL11.glCallList((int)travellingItem.displayList);
        } else {
            travellingItem.displayList = GLAllocation.func_74526_a((int)1);
            travellingItem.hasDisplayList = true;
            GL11.glNewList((int)travellingItem.displayList, (int)4865);
            if (itemstack.func_77973_b() instanceof IItemCustomPipeRender) {
                IItemCustomPipeRender render = (IItemCustomPipeRender)itemstack.func_77973_b();
                float itemScale = render.getPipeRenderScale(itemstack);
                GL11.glScalef((float)(renderScale * itemScale), (float)(renderScale * itemScale), (float)(renderScale * itemScale));
                itemScale = 1.0f / itemScale;
                if (!render.renderItemInPipe(itemstack, x, y, z)) {
                    dummyEntityItem.func_92058_a(itemstack);
                    customRenderItem.func_76986_a(dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                }
                GL11.glScalef((float)itemScale, (float)itemScale, (float)itemScale);
            } else {
                GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
                dummyEntityItem.func_92058_a(itemstack);
                customRenderItem.func_76986_a(dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            GL11.glEndList();
        }
        if (color != null) {
            this.bindTexture(TextureMap.field_110575_b);
            RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
            block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.ItemBox.ordinal());
            float pix = 0.0625f;
            float min = -4.0f * pix;
            float max = 4.0f * pix;
            block.minY = min;
            block.maxY = max;
            block.minZ = min;
            block.maxZ = max;
            block.minX = min;
            block.maxX = max;
            RenderUtils.setGLColorFromInt((int)color.getLightHex());
            RenderEntityBlock.INSTANCE.renderBlock(block);
        }
        GL11.glPopMatrix();
    }

    @Override
    public void render(Pipe<PipeTransportItems> pipe, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        int count = 0;
        Iterator<TravelingItem> iterator = ((PipeTransportItems)pipe.transport).items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (count >= 10) break;
            Position motion = new Position(0.0, 0.0, 0.0, item.toCenter ? item.input : item.output);
            motion.moveForwards((double)(item.getSpeed() * f));
            this.doRenderItem(item, x + item.xCoord - (double)pipe.container.field_145851_c + motion.x, y + item.yCoord - (double)pipe.container.field_145848_d + motion.y, z + item.zCoord - (double)pipe.container.field_145849_e + motion.z, 0.0f, item.color);
            ++count;
        }
        GL11.glPopMatrix();
    }

    static {
        customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }
}

