/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.FakeBlock;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.render.BCSimpleBlockRenderingHandler;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeRendererWorld
extends BCSimpleBlockRenderingHandler {
    public static int renderPass = -1;
    public static float zFightOffset = 2.4414062E-4f;
    private static final double[] CHEST_BB = new double[]{0.0, 0.0625, 0.0625, 0.875, 0.9375, 0.9375};

    public boolean renderPipe(RenderBlocks renderblocks, IBlockAccess iblockaccess, TileGenericPipe tile, int x, int y, int z) {
        PipeRenderState state = tile.renderState;
        IIconProvider icons = tile.getPipeIcons();
        FakeBlock fakeBlock = FakeBlock.INSTANCE;
        int glassColor = tile.getPipeColor();
        if (icons == null) {
            return false;
        }
        boolean rendered = false;
        if (renderPass == 0 || glassColor >= 0) {
            int connectivity = state.pipeConnectionMatrix.getMask();
            float[] dim = new float[6];
            if (renderPass == 1) {
                fakeBlock.setColor(ColorUtils.getRGBColor((int)glassColor));
            } else if (glassColor >= 0 && tile.getPipe() instanceof PipeStructureCobblestone) {
                if (glassColor == 0) {
                    fakeBlock.setColor(0xDFDFDF);
                } else {
                    fakeBlock.setColor(ColorUtils.getRGBColor((int)glassColor));
                }
            }
            if (connectivity != 63) {
                this.resetToCenterDimensions(dim);
                if (renderPass == 0) {
                    fakeBlock.getTextureState().set(icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.UNKNOWN)));
                } else {
                    fakeBlock.getTextureState().set(PipeIconProvider.TYPE.PipeStainedOverlay.getIcon());
                }
                this.fixForRenderPass(dim);
                this.renderTwoWayBlock(renderblocks, fakeBlock, x, y, z, dim, connectivity ^ 0x3F);
                rendered = true;
            }
            for (int dir = 0; dir < 6; ++dir) {
                double[] blockBB;
                int mask = 1 << dir;
                if ((connectivity & mask) == 0) continue;
                this.resetToCenterDimensions(dim);
                dim[dir / 2] = dir % 2 == 0 ? 0.0f : 0.75f;
                dim[dir / 2 + 3] = dir % 2 == 0 ? 0.25f : 1.0f;
                int renderMask = 3 << (dir & 6) ^ 0x3F;
                this.fixForRenderPass(dim);
                if (renderPass == 0) {
                    fakeBlock.getTextureState().set(icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.VALID_DIRECTIONS[dir])));
                } else {
                    fakeBlock.getTextureState().set(PipeIconProvider.TYPE.PipeStainedOverlay.getIcon());
                }
                this.renderTwoWayBlock(renderblocks, fakeBlock, x, y, z, dim, renderMask);
                rendered = true;
                if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) continue;
                ForgeDirection side = ForgeDirection.getOrientation((int)dir);
                int px = x + side.offsetX;
                int py = y + side.offsetY;
                int pz = z + side.offsetZ;
                Block block = iblockaccess.func_147439_a(px, py, pz);
                if (block instanceof BlockGenericPipe || block.func_149662_c()) continue;
                if (block instanceof BlockChest) {
                    blockBB = CHEST_BB;
                } else {
                    block.func_149719_a(iblockaccess, px, py, pz);
                    blockBB = new double[]{block.func_149665_z(), block.func_149704_x(), block.func_149706_B(), block.func_149669_A(), block.func_149753_y(), block.func_149693_C()};
                }
                if ((dir % 2 != 1 || blockBB[dir / 2] == 0.0) && (dir % 2 != 0 || blockBB[dir / 2 + 3] == 1.0)) continue;
                this.resetToCenterDimensions(dim);
                if (dir % 2 == 1) {
                    dim[dir / 2] = 0.0f;
                    dim[dir / 2 + 3] = (float)blockBB[dir / 2];
                } else {
                    dim[dir / 2] = (float)blockBB[dir / 2 + 3];
                    dim[dir / 2 + 3] = 1.0f;
                }
                this.fixForRenderPass(dim);
                this.renderTwoWayBlock(renderblocks, fakeBlock, x + side.offsetX, y + side.offsetY, z + side.offsetZ, dim, renderMask);
            }
            fakeBlock.setColor(0xFFFFFF);
        }
        renderblocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            PipePluggable p;
            IPipePluggableRenderer r;
            if (!tile.hasPipePluggable(dir) || (r = (p = tile.getPipePluggable(dir)).getRenderer()) == null) continue;
            r.renderPluggable(renderblocks, tile.getPipe(), dir, p, (ITextureStates)fakeBlock, renderPass, x, y, z);
        }
        return rendered;
    }

    private void fixForRenderPass(float[] dim) {
        if (renderPass == 1) {
            int i = 0;
            while (i < 3) {
                int n = i++;
                dim[n] = dim[n] + zFightOffset;
            }
            i = 3;
            while (i < 6) {
                int n = i++;
                dim[n] = dim[n] - zFightOffset;
            }
        }
    }

    private void resetToCenterDimensions(float[] dim) {
        for (int i = 0; i < 3; ++i) {
            dim[i] = 0.25f;
            dim[i + 3] = 0.75f;
        }
    }

    private void renderTwoWayBlock(RenderBlocks renderblocks, FakeBlock stateHost, int x, int y, int z, float[] dim, int mask) {
        assert (mask != 0);
        int c = stateHost.func_149635_D();
        float r = (float)((c & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((c & 0xFF00) >> 8) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        stateHost.setRenderMask(mask);
        renderblocks.func_147782_a((double)dim[2], (double)dim[0], (double)dim[1], (double)dim[5], (double)dim[3], (double)dim[4]);
        renderblocks.func_147736_d((Block)stateHost, x, y, z, r, g, b);
        stateHost.setRenderMask((mask & 0x15) << 1 | (mask & 0x2A) >> 1);
        renderblocks.func_147782_a((double)dim[5], (double)dim[3], (double)dim[4], (double)dim[2], (double)dim[0], (double)dim[1]);
        renderblocks.func_147736_d((Block)stateHost, x, y, z, r * 0.67f, g * 0.67f, b * 0.67f);
        stateHost.setRenderAllSides();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean rendered = false;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe pipeTile = (TileGenericPipe)tile;
            rendered = this.renderPipe(renderer, world, pipeTile, x, y, z);
        }
        if (!rendered) {
            this.fixEmptyAlphaPass(x, y, z);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return TransportProxy.pipeModel;
    }
}

