/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftTransport;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.PipeIconProvider;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class FacadeItemRenderer
implements IItemRenderer {
    private long lastTime = 0L;
    private int renderState = 0;

    private IIcon tryGetBlockIcon(Block block, int side, int decodedMeta) {
        IIcon icon = RenderUtils.tryGetBlockIcon((Block)block, (int)side, (int)decodedMeta);
        if (icon == null) {
            icon = PipeIconProvider.TYPE.TransparentFacade.getIcon();
        }
        return icon;
    }

    private void drawHollowCube(Tessellator tessellator, RenderBlocks render, Block block, int decodedMeta) {
        IIcon icon0 = this.tryGetBlockIcon(block, 0, decodedMeta);
        IIcon icon1 = this.tryGetBlockIcon(block, 1, decodedMeta);
        IIcon icon2 = this.tryGetBlockIcon(block, 2, decodedMeta);
        IIcon icon3 = this.tryGetBlockIcon(block, 3, decodedMeta);
        IIcon icon4 = this.tryGetBlockIcon(block, 4, decodedMeta);
        IIcon icon5 = this.tryGetBlockIcon(block, 5, decodedMeta);
        float width = 0.875f;
        float cavity = 0.25f;
        double innerWidth = 1.0f - cavity;
        tessellator.func_78382_b();
        render.func_147782_a(0.0, 0.0, (double)width, 1.0, 1.0, 1.0);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        render.func_147768_a(block, 0.0, 0.0, 0.0, icon0);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        render.func_147806_b(block, 0.0, 0.0, 0.0, icon1);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        render.func_147798_e(block, 0.0, 0.0, 0.0, icon4);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        render.func_147764_f(block, 0.0, 0.0, 0.0, icon5);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        render.func_147768_a(block, 0.0, innerWidth, 0.0, icon0);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        render.func_147806_b(block, 0.0, -innerWidth, 0.0, icon1);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        render.func_147798_e(block, innerWidth, 0.0, 0.0, icon4);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        render.func_147764_f(block, -innerWidth, 0.0, 0.0, icon5);
        render.field_152631_f = true;
        render.func_147782_a(0.0, 0.0, (double)width, (double)cavity, 1.0, 1.0);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        render.func_147761_c(block, 0.0, 0.0, 0.0, icon2);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        render.func_147734_d(block, 0.0, 0.0, 0.0, icon3);
        render.func_147782_a(innerWidth, 0.0, (double)width, 1.0, 1.0, 1.0);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        render.func_147761_c(block, 0.0, 0.0, 0.0, icon2);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        render.func_147734_d(block, 0.0, 0.0, 0.0, icon3);
        render.field_152631_f = false;
        render.func_147782_a((double)cavity, 0.0, (double)width, innerWidth, (double)cavity, 1.0);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        render.func_147761_c(block, 0.0, 0.0, 0.0, icon2);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        render.func_147734_d(block, 0.0, 0.0, 0.0, icon3);
        render.func_147782_a((double)cavity, innerWidth, (double)width, innerWidth, 1.0, 1.0);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        render.func_147761_c(block, 0.0, 0.0, 0.0, icon2);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        render.func_147734_d(block, 0.0, 0.0, 0.0, icon3);
        tessellator.func_78381_a();
    }

    private void renderFacadeItem(RenderBlocks render, ItemStack item, float translateX, float translateY, float translateZ) {
        if (this.lastTime < System.currentTimeMillis()) {
            this.renderState = (this.renderState + 1) % 12;
            this.lastTime = System.currentTimeMillis() + 1000L;
        }
        FacadeType type = ((IFacadeItem)item.func_77973_b()).getFacadeType(item);
        ItemFacade.FacadeState[] states = ItemFacade.getFacadeStates(item);
        ItemFacade.FacadeState activeState = null;
        if (states.length > 0) {
            if (type == FacadeType.Basic) {
                activeState = states[0];
            } else if (type == FacadeType.Phased) {
                activeState = states[this.renderState % states.length];
            }
        }
        Object block = activeState != null ? activeState.block : null;
        int decodedMeta = activeState != null ? activeState.metadata : 0;
        boolean hollow = activeState != null ? activeState.hollow : false;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (this.tryGetBlockIcon((Block)block, 0, decodedMeta) == null) {
            return;
        }
        GL11.glPushMatrix();
        if (block != null) {
            if (block.func_149701_w() > 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            }
            RenderUtils.setGLColorFromInt((int)block.func_149741_i(decodedMeta));
        }
        if (hollow) {
            GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
            this.drawHollowCube(tessellator, render, (Block)block, decodedMeta);
        } else {
            render.func_147782_a(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
            GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
            RenderUtils.drawBlockItem((RenderBlocks)render, (Tessellator)tessellator, (Block)block, (int)decodedMeta);
        }
        if (block != null && block.func_149701_w() > 0) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
        RenderUtils.setGLColorFromInt((int)0xFFFFFF);
        if (!hollow && block != null && (block.func_149688_o() == null || block.func_149688_o().func_76218_k())) {
            block = BuildCraftTransport.genericPipeBlock;
            IIcon textureID = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
            render.func_147782_a(0.25, 0.25, 0.25, 0.75, 0.75, 0.6875);
            GL11.glTranslatef((float)translateX, (float)translateY, (float)(translateZ + 0.25f));
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -0.0f, 0.0f);
            render.func_147768_a(block, 0.0, 0.0, 0.0, textureID);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            render.func_147806_b(block, 0.0, 0.0, 0.0, textureID);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            render.func_147761_c(block, 0.0, 0.0, 0.0, textureID);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            render.func_147734_d(block, 0.0, 0.0, 0.0, textureID);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            render.func_147798_e(block, 0.0, 0.0, 0.0, textureID);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            render.func_147764_f(block, 0.0, 0.0, 0.0, textureID);
            tessellator.func_78381_a();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.renderFacadeItem((RenderBlocks)data[0], item, -0.6f, 0.0f, -0.6f);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                this.renderFacadeItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case INVENTORY: {
                GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                this.renderFacadeItem((RenderBlocks)data[0], item, -0.3f, -0.35f, -0.7f);
                break;
            }
        }
    }
}

