/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.RFBattery;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePowerWood
extends Pipe<PipeTransportPower>
implements IPipeTransportPowerHook,
IEnergyHandler,
IRedstoneEngineReceiver,
IDebuggable {
    public final boolean[] powerSources = new boolean[6];
    protected int standardIconIndex = PipeIconProvider.TYPE.PipePowerWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    protected RFBattery battery = new RFBattery(40960, 40960, 0);
    private int requestedEnergy;
    private int lastRequestedEnergy;
    private int sources;
    private boolean allowExtraction = false;

    public PipePowerWood(Item item) {
        super(new PipeTransportPower(), item);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction != ForgeDirection.UNKNOWN && this.powerSources[direction.ordinal()]) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.sources = 0;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            boolean oldPowerSource = this.powerSources[o.ordinal()];
            if (!this.container.isPipeConnected(o)) {
                this.powerSources[o.ordinal()] = false;
            } else {
                TileEntity tile = this.container.getTile(o);
                this.powerSources[o.ordinal()] = ((PipeTransportPower)this.transport).isPowerSource(tile, o);
                if (this.powerSources[o.ordinal()]) {
                    ++this.sources;
                }
            }
            if (oldPowerSource == this.powerSources[o.ordinal()]) continue;
            this.container.scheduleRenderUpdate();
        }
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.sources <= 0) {
            this.battery.useEnergy(0, 50, false);
            this.requestedEnergy = 0;
            return;
        }
        if (this.allowExtraction) {
            this.allowExtraction = false;
            int energyMaxExtract = Math.min(((PipeTransportPower)this.transport).maxPower, this.battery.getMaxEnergyStored() - this.battery.getEnergyStored());
            energyMaxExtract /= this.sources;
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                int energyExtracted;
                if (!this.powerSources[o.ordinal()]) continue;
                TileEntity source = this.container.getNeighborTile(o);
                if (source instanceof IEnergyProvider) {
                    energyExtracted = this.battery.addEnergy(0, ((IEnergyProvider)source).extractEnergy(o.getOpposite(), energyMaxExtract, true), false);
                    ((IEnergyProvider)source).extractEnergy(o.getOpposite(), energyExtracted, false);
                    continue;
                }
                if (!(source instanceof IEnergyHandler)) continue;
                energyExtracted = this.battery.addEnergy(0, ((IEnergyHandler)source).extractEnergy(o.getOpposite(), energyMaxExtract, true), false);
                ((IEnergyHandler)source).extractEnergy(o.getOpposite(), energyExtracted, false);
            }
        }
        int energyToRemove = Math.min(this.battery.getEnergyStored(), this.requestedEnergy);
        energyToRemove /= this.sources;
        if (this.battery.getEnergyStored() > 0) {
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.powerSources[o.ordinal()]) continue;
                this.battery.setEnergy(this.battery.getEnergyStored() - (int)((PipeTransportPower)this.transport).receiveEnergy(o, energyToRemove));
            }
        }
        this.lastRequestedEnergy = this.requestedEnergy;
        this.requestedEnergy = 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagCompound batteryNBT = new NBTTagCompound();
        this.battery.writeToNBT(batteryNBT);
        data.func_74782_a("battery", (NBTBase)batteryNBT);
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            data.func_74757_a("powerSources[" + i + "]", this.powerSources[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.battery.readFromNBT(data.func_74775_l("battery"));
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.powerSources[i] = data.func_74767_n("powerSources[" + i + "]");
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int val) {
        return -1;
    }

    @Override
    public int requestEnergy(ForgeDirection from, int amount) {
        if (this.container.getTile(from) instanceof IPipeTile) {
            this.requestedEnergy += amount;
            return amount;
        }
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (from.ordinal() < 6 && this.container.getNeighborTile(from) instanceof IRedstoneEngine) {
            this.allowExtraction = true;
            return maxReceive;
        }
        if (from.ordinal() < 6 && this.powerSources[from.ordinal()]) {
            return this.battery.receiveEnergy(simulate ? Math.min(maxReceive, this.lastRequestedEnergy) : Math.min(maxReceive, this.battery.getMaxEnergyStored() - this.battery.getEnergyStored()), simulate);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.battery.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.battery.getMaxEnergyStored();
    }

    public boolean canConnectRedstoneEngine(ForgeDirection side) {
        return true;
    }

    public void getDebugInfo(List<String> info, ForgeDirection side, ItemStack debugger, EntityPlayer player) {
        info.add("Power Acceptor");
        info.add("- requestedEnergy: " + this.requestedEnergy);
        info.add("- lastRequestedEnergy: " + this.lastRequestedEnergy);
        info.add("- stored: " + this.battery.getEnergyStored() + "/" + this.battery.getMaxEnergyStored() + " RF");
    }
}

