/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.PowerMode;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.statements.ActionPowerLimiter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePowerIron
extends Pipe<PipeTransportPower> {
    public PipePowerIron(Item item) {
        super(new PipeTransportPower(), item);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (this.container == null) {
            return PipeIconProvider.TYPE.PipePowerIronM128.ordinal();
        }
        return PipeIconProvider.TYPE.PipePowerIronM2.ordinal() + this.container.func_145832_p();
    }

    @Override
    public boolean blockActivated(EntityPlayer player, ForgeDirection direction) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e)) {
            if (player.func_70093_af()) {
                this.setMode(this.getMode().getPrevious());
            } else {
                this.setMode(this.getMode().getNext());
            }
            if (this.getWorld().field_72995_K && !(player instanceof FakePlayer)) {
                if (BuildCraftCore.hidePowerNumbers) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.pipe.power.iron.mode.numberless", new Object[]{StringUtils.localize((String)("chat.pipe.power.iron.level." + this.getMode().maxPower))}));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.pipe.power.iron.mode", new Object[]{this.getMode().maxPower}));
                }
            }
            ((IToolWrench)equipped).wrenchUsed(player, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        ((PipeTransportPower)this.transport).maxPower = this.getMode().maxPower;
    }

    public PowerMode getMode() {
        return PowerMode.fromId((int)this.container.func_145832_p());
    }

    public void setMode(PowerMode mode) {
        if (mode.ordinal() != this.container.func_145832_p()) {
            this.container.func_145831_w().func_72921_c(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, mode.ordinal(), 3);
            this.container.scheduleRenderUpdate();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPowerLimiter)) continue;
            this.setMode(((ActionPowerLimiter)action.statement).limit);
            break;
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> action = super.getActions();
        for (PowerMode mode : PowerMode.VALUES) {
            action.add(BuildCraftTransport.actionPowerLimiter[mode.ordinal()]);
        }
        return action;
    }
}

