/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.utils.FluidUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.PipeFluidsWood;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsEmerald
extends PipeFluidsWood
implements ISerializable {
    private SimpleInventory filters = new SimpleInventory(1, "Filters", 1);

    public PipeFluidsEmerald(Item item) {
        super(item);
        this.standardIconIndex = PipeIconProvider.TYPE.PipeFluidsEmerald_Standard.ordinal();
        this.solidIconIndex = PipeIconProvider.TYPE.PipeAllEmerald_Solid.ordinal();
        ((PipeTransportFluids)this.transport).initFromPipe(this.getClass());
    }

    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    public int extractFluid(IFluidHandler fluidHandler, ForgeDirection side) {
        FluidStack targetFluidStack = FluidUtils.getFluidStackFromItemStack((ItemStack)this.filters.func_70301_a(0));
        if (targetFluidStack == null) {
            return super.extractFluid(fluidHandler, side);
        }
        int flowRate = ((PipeTransportFluids)this.transport).getFlowRate();
        FluidStack toExtract = new FluidStack(targetFluidStack, this.liquidToExtract > flowRate ? flowRate : this.liquidToExtract);
        FluidStack extracted = fluidHandler.drain(side.getOpposite(), toExtract, false);
        if (extracted != null) {
            toExtract.amount = ((PipeTransportFluids)this.transport).fill(side, extracted, true);
            if (toExtract.amount > 0) {
                fluidHandler.drain(side.getOpposite(), toExtract, true);
            }
        }
        return toExtract.amount;
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection side) {
        if (entityplayer.func_71045_bC() != null && Block.func_149634_a((Item)entityplayer.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer, side)) {
            return true;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 54, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        }
        return true;
    }

    @Override
    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.filters.writeToNBT(nbt);
        NetworkUtils.writeNBT((ByteBuf)data, (NBTTagCompound)nbt);
    }

    @Override
    public void readData(ByteBuf data) {
        NBTTagCompound nbt = NetworkUtils.readNBT((ByteBuf)data);
        this.filters.readFromNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
    }
}

