/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.utils.FluidUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IDiamondPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.events.PipeEventFluid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class PipeFluidsDiamond
extends Pipe<PipeTransportFluids>
implements IDiamondPipe {
    private FilterInventory filters = new FilterInventory(54, "Filters", 1);

    public PipeFluidsDiamond(Item item) {
        super(new PipeTransportFluids(), item);
        ((PipeTransportFluids)this.transport).initFromPipe(this.getClass());
    }

    @Override
    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        switch (direction) {
            case UNKNOWN: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_Center.ordinal();
            }
            case DOWN: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_Down.ordinal();
            }
            case UP: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_Up.ordinal();
            }
            case NORTH: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_North.ordinal();
            }
            case SOUTH: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_South.ordinal();
            }
            case WEST: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_West.ordinal();
            }
            case EAST: {
                return PipeIconProvider.TYPE.PipeFluidsDiamond_East.ordinal();
            }
        }
        throw new IllegalArgumentException("direction out of bounds");
    }

    @Override
    public int getIconIndexForItem() {
        return PipeIconProvider.TYPE.PipeFluidsDiamond_Item.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection direction) {
        if (entityplayer.func_71045_bC() != null && Block.func_149634_a((Item)entityplayer.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
            return false;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 50, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        }
        return true;
    }

    public void eventHandler(PipeEventFluid.FindDest event) {
        Fluid fluidInTank = event.fluidStack.getFluid();
        HashSet originalDestinations = new HashSet();
        originalDestinations.addAll(event.destinations.elementSet());
        boolean isFiltered = false;
        int[] filterCount = new int[6];
        for (ForgeDirection dir : originalDestinations) {
            if (!this.container.isPipeConnected(dir) || !this.filters.filteredDirections[dir.ordinal()]) continue;
            for (int slot = dir.ordinal() * 9; slot < dir.ordinal() * 9 + 9; ++slot) {
                if (this.filters.fluids[slot] == null || this.filters.fluids[slot].getID() != fluidInTank.getID()) continue;
                int n = dir.ordinal();
                filterCount[n] = filterCount[n] + 1;
                isFiltered = true;
            }
        }
        event.destinations.clear();
        if (!isFiltered) {
            for (ForgeDirection to : originalDestinations) {
                if (this.filters.filteredDirections[to.ordinal()]) continue;
                event.destinations.add((Object)to);
            }
        } else {
            for (ForgeDirection to : originalDestinations) {
                if (filterCount[to.ordinal()] <= 0) continue;
                event.destinations.add((Object)to, filterCount[to.ordinal()]);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        this.filters.func_70296_d();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
    }

    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.filters.writeToNBT(nbt);
        NetworkUtils.writeNBT((ByteBuf)data, (NBTTagCompound)nbt);
    }

    public void readData(ByteBuf data) {
        NBTTagCompound nbt = NetworkUtils.readNBT((ByteBuf)data);
        this.filters.readFromNBT(nbt);
        this.filters.func_70296_d();
    }

    private class FilterInventory
    extends SimpleInventory {
        public boolean[] filteredDirections;
        public Fluid[] fluids;

        public FilterInventory(int size, String invName, int invStackLimit) {
            super(size, invName, invStackLimit);
            this.filteredDirections = new boolean[6];
            this.fluids = new Fluid[54];
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return stack == null || FluidUtils.isFluidContainer((ItemStack)stack);
        }

        public void func_70296_d() {
            int i;
            for (i = 0; i < 6; ++i) {
                this.filteredDirections[i] = false;
            }
            for (i = 0; i < 54; ++i) {
                this.fluids[i] = FluidUtils.getFluidFromItemStack((ItemStack)this.func_70301_a(i));
                if (this.fluids[i] == null) continue;
                this.filteredDirections[i / 9] = true;
            }
        }
    }
}

