/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.network.PacketPipeTransportItemStackRequest;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import buildcraft.transport.network.PacketPowerUpdate;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketHandlerTransport
extends PacketHandler {
    protected void channelRead0(ChannelHandlerContext ctx, Packet packet) {
        super.channelRead0(ctx, packet);
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
            int packetID = packet.getID();
            switch (packetID) {
                case 4: {
                    this.onPacketPower(player, (PacketPowerUpdate)packet);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    this.onPipeTravelerUpdate(player, (PacketPipeTransportTraveler)packet);
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    ((PacketPipeTransportItemStackRequest)packet).sendDataToPlayer(player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onPipeTravelerUpdate(EntityPlayer player, PacketPipeTransportTraveler packet) {
        World world = player.field_70170_p;
        if (!world.func_72899_e(packet.posX, packet.posY, packet.posZ)) {
            return;
        }
        TileEntity entity = world.func_147438_o(packet.posX, packet.posY, packet.posZ);
        if (!(entity instanceof IPipeTile)) {
            return;
        }
        IPipeTile pipe = (IPipeTile)entity;
        if (pipe.getPipe() == null) {
            return;
        }
        if (!(((Pipe)pipe.getPipe()).transport instanceof PipeTransportItems)) {
            return;
        }
        ((PipeTransportItems)((Pipe)pipe.getPipe()).transport).handleTravelerPacket(packet);
    }

    private void onPacketPower(EntityPlayer player, PacketPowerUpdate packetPower) {
        World world = player.field_70170_p;
        if (!world.func_72899_e(packetPower.posX, packetPower.posY, packetPower.posZ)) {
            return;
        }
        TileEntity entity = world.func_147438_o(packetPower.posX, packetPower.posY, packetPower.posZ);
        if (!(entity instanceof IPipeTile)) {
            return;
        }
        IPipeTile pipe = (IPipeTile)entity;
        if (pipe.getPipe() == null) {
            return;
        }
        if (!(((Pipe)pipe.getPipe()).transport instanceof PipeTransportPower)) {
            return;
        }
        ((PipeTransportPower)((Pipe)pipe.getPipe()).transport).handlePowerPacket(packetPower);
    }
}

