/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.buttons.GuiImageButton;
import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.IGuiReturnHandler;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.gui.ContainerEmeraldPipe;
import buildcraft.transport.pipes.PipeItemsEmerald;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiEmeraldPipe
extends GuiBuildCraft
implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emerald.png");
    private static final ResourceLocation TEXTURE_BUTTON = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emerald_button.png");
    private static final int WHITE_LIST_BUTTON_ID = 1;
    private static final int BLACK_LIST_BUTTON_ID = 2;
    private static final int ROUND_ROBIN_BUTTON_ID = 3;
    private GuiImageButton whiteListButton;
    private GuiImageButton blackListButton;
    private GuiImageButton roundRobinButton;
    private PipeItemsEmerald pipe;

    public GuiEmeraldPipe(IInventory playerInventory, PipeItemsEmerald pipe) {
        super((BuildCraftContainer)new ContainerEmeraldPipe(playerInventory, pipe), pipe.getFilters(), TEXTURE);
        this.pipe = pipe;
        this.field_146999_f = 175;
        this.field_147000_g = 161;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.whiteListButton = new GuiImageButton(1, this.field_147003_i + 7, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 19, 19);
        this.whiteListButton.registerListener((IButtonClickEventListener)this);
        this.whiteListButton.setToolTip(new ToolTip(500, new ToolTipLine[]{new ToolTipLine(StatCollector.func_74838_a((String)"tip.PipeItemsEmerald.whitelist"))}));
        this.field_146292_n.add(this.whiteListButton);
        this.blackListButton = new GuiImageButton(2, this.field_147003_i + 7 + 18, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 37, 19);
        this.blackListButton.registerListener((IButtonClickEventListener)this);
        this.blackListButton.setToolTip(new ToolTip(500, new ToolTipLine[]{new ToolTipLine(StatCollector.func_74838_a((String)"tip.PipeItemsEmerald.blacklist"))}));
        this.field_146292_n.add(this.blackListButton);
        this.roundRobinButton = new GuiImageButton(3, this.field_147003_i + 7 + 36, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 55, 19);
        this.roundRobinButton.registerListener((IButtonClickEventListener)this);
        this.roundRobinButton.setToolTip(new ToolTip(500, new ToolTipLine[]{new ToolTipLine(StatCollector.func_74838_a((String)"tip.PipeItemsEmerald.roundrobin"))}));
        this.field_146292_n.add(this.roundRobinButton);
        switch (this.pipe.getSettings().getFilterMode()) {
            case WHITE_LIST: {
                this.whiteListButton.activate();
                break;
            }
            case BLACK_LIST: {
                this.blackListButton.activate();
                break;
            }
            case ROUND_ROBIN: {
                this.roundRobinButton.activate();
            }
        }
    }

    public void handleButtonClick(IButtonClickEventTrigger sender, int buttonId) {
        switch (buttonId) {
            case 1: {
                this.whiteListButton.activate();
                this.blackListButton.deActivate();
                this.roundRobinButton.deActivate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.WHITE_LIST);
                break;
            }
            case 2: {
                this.whiteListButton.deActivate();
                this.blackListButton.activate();
                this.roundRobinButton.deActivate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.BLACK_LIST);
                break;
            }
            case 3: {
                this.whiteListButton.deActivate();
                this.blackListButton.deActivate();
                this.roundRobinButton.activate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.ROUND_ROBIN);
            }
        }
        if (this.pipe.getWorld().field_72995_K) {
            PacketGuiReturn pkt = new PacketGuiReturn((IGuiReturnHandler)this.pipe.getContainer());
            pkt.sendPacket();
        }
    }

    protected void func_146979_b(int par1, int par2) {
        String title = StringUtils.localize((String)"gui.pipes.emerald.title");
        this.field_146289_q.func_78276_b(title, (this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize((String)"gui.inventory"), 8, this.field_147000_g - 93, 0x404040);
    }

    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

