/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.slots.SlotPhantom;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.gui.widgets.ButtonWidget;
import buildcraft.core.lib.gui.widgets.Widget;
import buildcraft.core.lib.network.IGuiReturnHandler;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.utils.RevolvingList;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEmzuliPipe
extends BuildCraftContainer {
    private final PipeItemsEmzuli pipe;
    private final IInventory filterInv;
    private final byte[] prevSlotColors = new byte[4];
    private final PaintWidget[] paintWidgets = new PaintWidget[4];

    public ContainerEmzuliPipe(IInventory playerInventory, PipeItemsEmzuli pipe) {
        super(pipe.getFilters().func_70302_i_());
        this.pipe = pipe;
        this.filterInv = pipe.getFilters();
        this.paintWidgets[0] = new PaintWidget(0, 51, 19);
        this.addWidget((Widget)this.paintWidgets[0]);
        this.paintWidgets[1] = new PaintWidget(1, 104, 19);
        this.addWidget((Widget)this.paintWidgets[1]);
        this.paintWidgets[2] = new PaintWidget(2, 51, 47);
        this.addWidget((Widget)this.paintWidgets[2]);
        this.paintWidgets[3] = new PaintWidget(3, 104, 47);
        this.addWidget((Widget)this.paintWidgets[3]);
        this.addSlot((Slot)new SlotPhantom(this.filterInv, 0, 25, 21));
        this.addSlot((Slot)new SlotPhantom(this.filterInv, 1, 134, 21));
        this.addSlot((Slot)new SlotPhantom(this.filterInv, 2, 25, 49));
        this.addSlot((Slot)new SlotPhantom(this.filterInv, 3, 134, 49));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.func_75146_a(new Slot(playerInventory, k1 + l * 9 + 9, 8 + k1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot(playerInventory, i1, 8 + i1 * 18, 142));
        }
    }

    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        for (int slot = 0; slot < this.pipe.slotColors.length; ++slot) {
            this.prevSlotColors[slot] = this.pipe.slotColors[slot];
            player.func_71112_a((Container)this, slot, (int)this.pipe.slotColors[slot]);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (Object crafter : this.field_75149_d) {
            ICrafting player = (ICrafting)crafter;
            for (int slot = 0; slot < this.pipe.slotColors.length; ++slot) {
                if (this.prevSlotColors[slot] == this.pipe.slotColors[slot]) continue;
                player.func_71112_a((Container)this, slot, (int)this.pipe.slotColors[slot]);
            }
        }
        System.arraycopy(this.pipe.slotColors, 0, this.prevSlotColors, 0, this.pipe.slotColors.length);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.paintWidgets[id].colors.setCurrent(data == 0 ? null : EnumColor.fromId((int)(data - 1)));
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.pipe.container.isUseableByPlayer(entityplayer);
    }

    private class PaintWidget
    extends ButtonWidget {
        private final int slot;
        private RevolvingList<EnumColor> colors;
        private ToolTip toolTip;

        public PaintWidget(int slot, int x, int y) {
            super(x, y, 176, 0, 20, 20);
            this.colors = new RevolvingList();
            this.toolTip = new ToolTip(500, new ToolTipLine[0]){

                public void refresh() {
                    PaintWidget.this.toolTip.clear();
                    EnumColor color = (EnumColor)PaintWidget.this.colors.getCurrent();
                    if (color != null) {
                        PaintWidget.this.toolTip.add((Object)new ToolTipLine(String.format(StringUtils.localize((String)"gui.pipes.emzuli.paint"), color.getLocalizedName())));
                    } else {
                        PaintWidget.this.toolTip.add((Object)new ToolTipLine(StringUtils.localize((String)"gui.pipes.emzuli.nopaint")));
                    }
                }
            };
            this.slot = slot;
            this.colors.add(null);
            this.colors.addAll(Arrays.asList(EnumColor.VALUES));
        }

        public void draw(GuiBuildCraft gui, int guiX, int guiY, int mouseX, int mouseY) {
            super.draw(gui, guiX, guiY, mouseX, mouseY);
            EnumColor color = (EnumColor)this.colors.getCurrent();
            if (color != null) {
                gui.bindTexture(TextureMap.field_110576_c);
                gui.func_94065_a(guiX + this.x + 2, guiY + this.y + 2, BuildCraftTransport.actionPipeColor[color.ordinal()].getIcon(), 16, 16);
            } else {
                gui.func_73729_b(guiX + this.x + 2, guiY + this.y + 2, this.u, this.v + this.h + this.h, 16, 16);
            }
        }

        public void onRelease(int mouseButton) {
            switch (mouseButton) {
                case 0: {
                    this.colors.rotateLeft();
                    break;
                }
                case 1: {
                    this.colors.rotateRight();
                    break;
                }
                case 2: {
                    this.colors.setCurrent(null);
                }
            }
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream data = new DataOutputStream(bytes);
                data.writeByte(this.slot);
                EnumColor color = (EnumColor)this.colors.getCurrent();
                data.writeByte(color == null ? 0 : color.ordinal() + 1);
                PacketGuiReturn pkt = new PacketGuiReturn((IGuiReturnHandler)ContainerEmzuliPipe.this.pipe.getContainer(), bytes.toByteArray());
                pkt.sendPacket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public ToolTip getToolTip() {
            return this.toolTip;
        }
    }
}

