/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.IGate;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.transport.gates.GateExpansionBuildcraft;
import buildcraft.transport.statements.TriggerClockTimer;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public final class GateExpansionTimer
extends GateExpansionBuildcraft
implements IGateExpansion {
    public static GateExpansionTimer INSTANCE = new GateExpansionTimer();

    private GateExpansionTimer() {
        super("timer");
    }

    public GateExpansionController makeController(TileEntity pipeTile) {
        return new GateExpansionControllerTimer(pipeTile);
    }

    private class GateExpansionControllerTimer
    extends GateExpansionController {
        private final Timer[] timers;

        public GateExpansionControllerTimer(TileEntity pipeTile) {
            super((IGateExpansion)GateExpansionTimer.this, pipeTile);
            this.timers = new Timer[TriggerClockTimer.Time.VALUES.length];
            for (TriggerClockTimer.Time time : TriggerClockTimer.Time.VALUES) {
                this.timers[time.ordinal()] = new Timer(time);
            }
        }

        public boolean isTriggerActive(IStatement trigger, IStatementParameter[] parameters) {
            if (trigger instanceof TriggerClockTimer) {
                TriggerClockTimer timerTrigger = (TriggerClockTimer)trigger;
                return this.timers[timerTrigger.time.ordinal()].isActive();
            }
            return super.isTriggerActive(trigger, parameters);
        }

        public void addTriggers(List<ITriggerInternal> list) {
            super.addTriggers(list);
            for (TriggerClockTimer.Time time : TriggerClockTimer.Time.VALUES) {
                list.add(BuildCraftTransport.triggerTimer[time.ordinal()]);
            }
        }

        public void tick(IGate gate) {
            for (Timer timer : this.timers) {
                timer.tick();
            }
        }

        private class Timer {
            private static final int ACTIVE_TIME = 5;
            private final TriggerClockTimer.Time time;
            private int clock;

            public Timer(TriggerClockTimer.Time time) {
                this.time = time;
            }

            public void tick() {
                this.clock = this.clock > -5 ? --this.clock : this.time.delay * 20 + 5;
            }

            public boolean isActive() {
                return this.clock < 0;
            }
        }
    }
}

