/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.utils.MathUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportFluidsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.network.PacketFluidUpdate;
import buildcraft.transport.pipes.PipeFluidsClay;
import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsDiamond;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeFluidsGold;
import buildcraft.transport.pipes.PipeFluidsIron;
import buildcraft.transport.pipes.PipeFluidsQuartz;
import buildcraft.transport.pipes.PipeFluidsSandstone;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsVoid;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.events.PipeEventFluid;
import buildcraft.transport.utils.FluidRenderData;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.Multiset;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeTransportFluids
extends PipeTransport
implements IFluidHandler,
IDebuggable {
    public static final Map<Class<? extends Pipe<?>>, Integer> fluidCapacities = new HashMap();
    public static int MAX_TRAVEL_DELAY = 12;
    public static short INPUT_TTL = (short)60;
    public static short OUTPUT_TTL = (short)80;
    public static short OUTPUT_COOLDOWN = (short)30;
    private static int NETWORK_SYNC_TICKS = BuildCraftCore.updateFactor / 2;
    private static final ForgeDirection[] directions = ForgeDirection.VALID_DIRECTIONS;
    private static final ForgeDirection[] orientations = ForgeDirection.values();
    public PipeSection[] sections = new PipeSection[7];
    public FluidStack fluidType;
    public FluidRenderData renderCache = new FluidRenderData();
    private final SafeTimeTracker networkSyncTracker = new SafeTimeTracker((long)NETWORK_SYNC_TICKS);
    private final TransferState[] transferState = new TransferState[directions.length];
    private final int[] inputPerTick = new int[directions.length];
    private final short[] inputTTL = new short[]{0, 0, 0, 0, 0, 0};
    private final short[] outputTTL = new short[]{OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL};
    private final short[] outputCooldown = new short[]{0, 0, 0, 0, 0, 0};
    private final boolean[] canReceiveCache = new boolean[6];
    private int clientSyncCounter = 0;
    private int capacity;
    private int flowRate;
    private int travelDelay = MAX_TRAVEL_DELAY;

    public PipeTransportFluids() {
        for (ForgeDirection direction : directions) {
            this.sections[direction.ordinal()] = new PipeSection();
            this.transferState[direction.ordinal()] = TransferState.None;
        }
        this.sections[6] = new PipeSection();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getFlowRate() {
        return this.flowRate;
    }

    public void initFromPipe(Class<? extends Pipe<?>> pipeClass) {
        this.capacity = 25 * Math.min(1000, BuildCraftTransport.pipeFluidsBaseFlowRate);
        this.flowRate = fluidCapacities.get(pipeClass);
        this.travelDelay = MathUtils.clamp((int)Math.round(16.0f / (float)(this.flowRate / BuildCraftTransport.pipeFluidsBaseFlowRate)), (int)1, (int)MAX_TRAVEL_DELAY);
    }

    @Override
    public void initialize() {
        super.initialize();
        for (ForgeDirection d : directions) {
            this.canReceiveCache[d.ordinal()] = this.canReceiveFluid(d);
        }
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.FLUID;
    }

    private boolean canReceiveFluid(ForgeDirection o) {
        Pipe pipe;
        TileEntity tile = this.container.getTile(o);
        if (!this.container.isPipeConnected(o)) {
            return false;
        }
        if (tile instanceof IPipeTile && ((pipe = (Pipe)((IPipeTile)tile).getPipe()) == null || !this.inputOpen(o.getOpposite()))) {
            return false;
        }
        return tile instanceof IFluidHandler;
    }

    @Override
    public void updateEntity() {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        this.moveFluids();
        if (this.networkSyncTracker.markTimeIfDelay(this.container.func_145831_w())) {
            PacketFluidUpdate packet;
            boolean init = false;
            if ((long)(++this.clientSyncCounter) > BuildCraftCore.longUpdateFactor * 2L) {
                this.clientSyncCounter = 0;
                init = true;
            }
            if ((packet = this.computeFluidUpdate(init, true)) != null) {
                BuildCraftTransport.instance.sendToPlayers((Packet)packet, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
            }
        }
    }

    private void moveFluids() {
        if (this.fluidType != null) {
            int newTimeSlot = (int)(this.container.func_145831_w().func_82737_E() % (long)this.travelDelay);
            int outputCount = this.computeCurrentConnectionStatesAndTickFlows((short)(newTimeSlot > 0 && newTimeSlot < this.travelDelay ? newTimeSlot : 0));
            if (this.fluidType != null) {
                this.moveFromPipe(outputCount);
                this.moveFromCenter();
                this.moveToCenter();
            }
        } else {
            this.computeTTLs();
        }
    }

    private void moveFromPipe(int outputCount) {
        if (outputCount > 0) {
            for (ForgeDirection o : directions) {
                TileEntity target;
                if (this.transferState[o.ordinal()] != TransferState.Output || !((target = this.container.getTile(o)) instanceof IFluidHandler)) continue;
                PipeSection section = this.sections[o.ordinal()];
                FluidStack liquidToPush = new FluidStack(this.fluidType, section.drain(this.flowRate, false));
                if (liquidToPush.amount <= 0) continue;
                int filled = ((IFluidHandler)target).fill(o.getOpposite(), liquidToPush, true);
                if (filled <= 0) {
                    int n = o.ordinal();
                    this.outputTTL[n] = (short)(this.outputTTL[n] - 1);
                    continue;
                }
                section.drain(filled, true);
            }
        }
    }

    private void moveFromCenter() {
        int pushAmount = this.sections[6].amount;
        int totalAvailable = this.sections[6].getAvailable();
        if (totalAvailable < 1 || pushAmount < 1) {
            return;
        }
        int testAmount = this.flowRate;
        EnumMultiset realDirections = EnumMultiset.create(ForgeDirection.class);
        for (ForgeDirection direction : directions) {
            if (this.transferState[direction.ordinal()] != TransferState.Output) continue;
            realDirections.add((Object)direction);
        }
        if (realDirections.size() > 0) {
            this.container.pipe.eventBus.handleEvent(PipeEventFluid.FindDest.class, new PipeEventFluid.FindDest(this.container.pipe, new FluidStack(this.fluidType, pushAmount), (Multiset<ForgeDirection>)realDirections));
            float min = (float)Math.min(this.flowRate * realDirections.size(), totalAvailable) / (float)this.flowRate / (float)realDirections.size();
            for (ForgeDirection direction : realDirections.elementSet()) {
                int available = this.sections[direction.ordinal()].fill(testAmount, false);
                int amountToPush = (int)((float)available * min * (float)realDirections.count((Object)direction));
                if (amountToPush < 1) {
                    ++amountToPush;
                }
                if ((amountToPush = this.sections[6].drain(amountToPush, false)) <= 0) continue;
                int filled = this.sections[direction.ordinal()].fill(amountToPush, true);
                this.sections[6].drain(filled, true);
            }
        }
    }

    private void moveToCenter() {
        int transferInCount = 0;
        int spaceAvailable = this.getCapacity() - this.sections[6].amount;
        for (ForgeDirection dir : directions) {
            this.inputPerTick[dir.ordinal()] = 0;
            if (this.transferState[dir.ordinal()] == TransferState.Output) continue;
            this.inputPerTick[dir.ordinal()] = this.sections[dir.ordinal()].drain(this.flowRate, false);
            if (this.inputPerTick[dir.ordinal()] <= 0) continue;
            ++transferInCount;
        }
        float min = (float)Math.min(this.flowRate * transferInCount, spaceAvailable) / (float)this.flowRate / (float)transferInCount;
        for (ForgeDirection dir : directions) {
            int amountToPush;
            if (this.inputPerTick[dir.ordinal()] <= 0) continue;
            int amountToDrain = (int)((float)this.inputPerTick[dir.ordinal()] * min);
            if (amountToDrain < 1) {
                ++amountToDrain;
            }
            if ((amountToPush = this.sections[dir.ordinal()].drain(amountToDrain, false)) <= 0) continue;
            int filled = this.sections[6].fill(amountToPush, true);
            this.sections[dir.ordinal()].drain(filled, true);
        }
    }

    private void computeTTLs() {
        for (int i = 0; i < 6; ++i) {
            if (this.transferState[i] == TransferState.Input) {
                if (this.inputTTL[i] > 0) {
                    int n = i;
                    this.inputTTL[n] = (short)(this.inputTTL[n] - 1);
                } else {
                    this.transferState[i] = TransferState.None;
                }
            }
            if (this.outputCooldown[i] <= 0) continue;
            int n = i;
            this.outputCooldown[n] = (short)(this.outputCooldown[n] - 1);
        }
    }

    private int computeCurrentConnectionStatesAndTickFlows(short newTimeSlot) {
        int outputCount = 0;
        int fluidAmount = 0;
        for (ForgeDirection direction : orientations) {
            int dirI = direction.ordinal();
            PipeSection section = this.sections[dirI];
            fluidAmount += section.amount;
            section.setTime(newTimeSlot);
            section.moveFluids();
            if (direction == ForgeDirection.UNKNOWN) continue;
            if (this.transferState[dirI] == TransferState.Input) {
                int n = dirI;
                this.inputTTL[n] = (short)(this.inputTTL[n] - 1);
                if (this.inputTTL[dirI] > 0) continue;
                this.transferState[dirI] = TransferState.None;
                continue;
            }
            if (!this.container.pipe.outputOpen(direction)) {
                this.transferState[dirI] = TransferState.None;
                continue;
            }
            if (this.outputCooldown[dirI] > 0) {
                int n = dirI;
                this.outputCooldown[n] = (short)(this.outputCooldown[n] - 1);
                continue;
            }
            if (this.outputTTL[dirI] <= 0) {
                this.transferState[dirI] = TransferState.None;
                this.outputCooldown[dirI] = OUTPUT_COOLDOWN;
                this.outputTTL[dirI] = OUTPUT_TTL;
                continue;
            }
            if (!this.canReceiveCache[dirI] || !this.container.pipe.outputOpen(direction)) continue;
            this.transferState[dirI] = TransferState.Output;
            ++outputCount;
        }
        if (fluidAmount == 0) {
            this.setFluidType(null);
        }
        return outputCount;
    }

    private PacketFluidUpdate computeFluidUpdate(boolean initPacket, boolean persistChange) {
        boolean changed = false;
        BitSet delta = new BitSet(8);
        FluidRenderData renderCacheCopy = this.renderCache;
        if (initPacket || this.fluidType == null && renderCacheCopy.fluidID != 0 || this.fluidType != null && renderCacheCopy.fluidID != this.fluidType.getFluid().getID()) {
            changed = true;
            this.renderCache.fluidID = this.fluidType != null ? this.fluidType.getFluid().getID() : 0;
            this.renderCache.color = this.fluidType != null ? this.fluidType.getFluid().getColor(this.fluidType) : 0;
            this.renderCache.flags = FluidRenderData.getFlags(this.fluidType);
            delta.set(0);
        }
        for (ForgeDirection dir : orientations) {
            int camount;
            int pamount = this.renderCache.amount[dir.ordinal()];
            int displayQty = (pamount * 4 + (camount = this.sections[dir.ordinal()].amount)) / 5;
            if (displayQty == 0 && camount > 0 || initPacket) {
                displayQty = camount;
            }
            if (pamount == (displayQty = Math.min(this.getCapacity(), displayQty)) && !initPacket) continue;
            changed = true;
            this.renderCache.amount[dir.ordinal()] = displayQty;
            delta.set(dir.ordinal() + 1);
        }
        if (persistChange) {
            this.renderCache = renderCacheCopy;
        }
        if (changed || initPacket) {
            PacketFluidUpdate packet = new PacketFluidUpdate(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, initPacket, this.getCapacity() > 255);
            packet.renderCache = renderCacheCopy;
            packet.delta = delta;
            return packet;
        }
        return null;
    }

    private void setFluidType(FluidStack type) {
        this.fluidType = type;
    }

    @Override
    public void sendDescriptionPacket() {
        super.sendDescriptionPacket();
        PacketFluidUpdate update = this.computeFluidUpdate(true, true);
        BuildCraftTransport.instance.sendToPlayers((Packet)update, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
    }

    public FluidStack getStack(ForgeDirection direction) {
        if (this.fluidType == null) {
            return null;
        }
        return new FluidStack(this.fluidType, this.sections[direction.ordinal()].amount);
    }

    @Override
    public void dropContents() {
        if (this.fluidType != null) {
            int totalAmount = 0;
            for (int i = 0; i < 7; ++i) {
                totalAmount += this.sections[i].amount;
            }
            if (totalAmount > 0) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(new FluidStack(this.fluidType, totalAmount), this.getWorld(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e));
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("fluid")) {
            this.setFluidType(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound.func_74775_l("fluid")));
        } else {
            this.setFluidType(null);
        }
        for (ForgeDirection direction : orientations) {
            if (nbttagcompound.func_74764_b("tank[" + direction.ordinal() + "]")) {
                NBTTagCompound compound = nbttagcompound.func_74775_l("tank[" + direction.ordinal() + "]");
                if (compound.func_74764_b("FluidType")) {
                    FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
                    if (this.fluidType == null) {
                        this.setFluidType(stack);
                    }
                    if (stack.isFluidEqual(this.fluidType)) {
                        this.sections[direction.ordinal()].readFromNBT(compound);
                    }
                } else {
                    this.sections[direction.ordinal()].readFromNBT(compound);
                }
            }
            if (direction == ForgeDirection.UNKNOWN) continue;
            this.transferState[direction.ordinal()] = TransferState.values()[nbttagcompound.func_74765_d("transferState[" + direction.ordinal() + "]")];
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.fluidType != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.fluidType.writeToNBT(fluidTag);
            nbttagcompound.func_74782_a("fluid", (NBTBase)fluidTag);
            for (ForgeDirection direction : orientations) {
                NBTTagCompound subTag = new NBTTagCompound();
                this.sections[direction.ordinal()].writeToNBT(subTag);
                nbttagcompound.func_74782_a("tank[" + direction.ordinal() + "]", (NBTBase)subTag);
                if (direction == ForgeDirection.UNKNOWN) continue;
                nbttagcompound.func_74777_a("transferState[" + direction.ordinal() + "]", (short)this.transferState[direction.ordinal()].ordinal());
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && !this.inputOpen(from)) {
            return 0;
        }
        if (resource == null || this.fluidType != null && !resource.isFluidEqual(this.fluidType)) {
            return 0;
        }
        int filled = this.container.pipe instanceof IPipeTransportFluidsHook ? ((IPipeTransportFluidsHook)((Object)this.container.pipe)).fill(from, resource, doFill) : this.sections[from.ordinal()].fill(resource.amount, doFill);
        if (doFill && filled > 0) {
            if (this.fluidType == null) {
                this.setFluidType(new FluidStack(resource, 0));
            }
            if (from != ForgeDirection.UNKNOWN) {
                this.transferState[from.ordinal()] = TransferState.Input;
                this.inputTTL[from.ordinal()] = INPUT_TTL;
            }
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.inputOpen(from);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.fluidType, this.sections[from.ordinal()].amount)};
    }

    @Override
    public void onNeighborChange(ForgeDirection direction) {
        super.onNeighborChange(direction);
        if (!this.container.isPipeConnected(direction)) {
            this.sections[direction.ordinal()].reset();
            this.transferState[direction.ordinal()] = TransferState.None;
            this.renderCache.amount[direction.ordinal()] = 0;
            this.canReceiveCache[direction.ordinal()] = false;
        } else {
            this.canReceiveCache[direction.ordinal()] = this.canReceiveFluid(direction);
        }
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2;
        if (tile instanceof IPipeTile && BlockGenericPipe.isValid(pipe2 = (Pipe)((IPipeTile)tile).getPipe()) && !(pipe2.transport instanceof PipeTransportFluids)) {
            return false;
        }
        if (tile instanceof IFluidHandler) {
            return true;
        }
        return tile instanceof IPipeTile;
    }

    public void getDebugInfo(List<String> info, ForgeDirection side, ItemStack debugger, EntityPlayer player) {
        int[] amount = new int[7];
        for (int i = 0; i < 7; ++i) {
            if (this.sections[i] == null) continue;
            amount[i] = this.sections[i].amount;
        }
        info.add(String.format("PipeTransportFluids (%s, %d mB, %d mB/t)", this.fluidType != null ? this.fluidType.getLocalizedName() : "Empty", this.capacity, this.flowRate));
        info.add("- Stored: " + Arrays.toString(amount));
    }

    static {
        fluidCapacities.put(PipeFluidsVoid.class, 1 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsWood.class, 1 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsCobblestone.class, 1 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsSandstone.class, 2 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsStone.class, 2 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsClay.class, 4 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsEmerald.class, 4 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsIron.class, 4 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsQuartz.class, 4 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsDiamond.class, 8 * BuildCraftTransport.pipeFluidsBaseFlowRate);
        fluidCapacities.put(PipeFluidsGold.class, 8 * BuildCraftTransport.pipeFluidsBaseFlowRate);
    }

    public static enum TransferState {
        None,
        Input,
        Output;

    }

    public class PipeSection {
        public int amount;
        private short currentTime = 0;
        private short[] incoming = new short[MAX_TRAVEL_DELAY];

        public int fill(int maxFill, boolean doFill) {
            int amountToFill = Math.min(this.getMaxFillRate(), maxFill);
            if (amountToFill <= 0) {
                return 0;
            }
            if (doFill) {
                short s = this.currentTime;
                this.incoming[s] = (short)(this.incoming[s] + amountToFill);
                this.amount += amountToFill;
            }
            return amountToFill;
        }

        public int drain(int maxDrain, boolean doDrain) {
            int maxToDrain = this.getAvailable();
            if (maxToDrain > maxDrain) {
                maxToDrain = maxDrain;
            }
            if (maxToDrain > PipeTransportFluids.this.flowRate) {
                maxToDrain = PipeTransportFluids.this.flowRate;
            }
            if (maxToDrain <= 0) {
                return 0;
            }
            if (doDrain) {
                this.amount -= maxToDrain;
            }
            return maxToDrain;
        }

        public void moveFluids() {
            this.incoming[this.currentTime] = 0;
        }

        public void setTime(short newTime) {
            this.currentTime = newTime;
        }

        public void reset() {
            this.amount = 0;
            this.incoming = new short[MAX_TRAVEL_DELAY];
        }

        public int getAvailable() {
            int all = this.amount;
            for (short slot : this.incoming) {
                all -= slot;
            }
            return all;
        }

        public int getMaxFillRate() {
            return Math.min(PipeTransportFluids.this.getCapacity() - this.amount, PipeTransportFluids.this.flowRate - this.incoming[this.currentTime]);
        }

        public void readFromNBT(NBTTagCompound compoundTag) {
            this.amount = compoundTag.func_74765_d("capacity");
            for (int i = 0; i < PipeTransportFluids.this.travelDelay; ++i) {
                this.incoming[i] = compoundTag.func_74765_d("in[" + i + "]");
            }
        }

        public void writeToNBT(NBTTagCompound subTag) {
            subTag.func_74777_a("capacity", (short)this.amount);
            for (int i = 0; i < PipeTransportFluids.this.travelDelay; ++i) {
                subTag.func_74777_a("in[" + i + "]", this.incoming[i]);
            }
        }
    }
}

