/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.ISerializable;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.utils.ConnectionMatrix;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePluggableState
implements ISerializable {
    private PipePluggable[] pluggables = new PipePluggable[6];
    private final ConnectionMatrix pluggableMatrix = new ConnectionMatrix();

    public PipePluggable[] getPluggables() {
        return this.pluggables;
    }

    public void setPluggables(PipePluggable[] pluggables) {
        this.pluggables = pluggables;
    }

    public void writeData(ByteBuf data) {
        this.pluggableMatrix.clean();
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            this.pluggableMatrix.setConnected(forgeDirection, this.pluggables[forgeDirection.ordinal()] != null);
        }
        this.pluggableMatrix.writeData(data);
        for (ForgeDirection forgeDirection : this.pluggables) {
            if (forgeDirection == null) continue;
            data.writeShort(PipeManager.pipePluggables.indexOf(forgeDirection.getClass()));
            forgeDirection.writeData(data);
        }
    }

    public void readData(ByteBuf data) {
        this.pluggableMatrix.readData(data);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.pluggableMatrix.isConnected(dir)) {
                try {
                    Class pc = (Class)PipeManager.pipePluggables.get(data.readUnsignedShort());
                    if (this.pluggables[dir.ordinal()] == null || pc != this.pluggables[dir.ordinal()].getClass()) {
                        PipePluggable p;
                        this.pluggables[dir.ordinal()] = p = (PipePluggable)pc.newInstance();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.pluggables[dir.ordinal()] == null) continue;
                this.pluggables[dir.ordinal()].readData(data);
                continue;
            }
            this.pluggables[dir.ordinal()] = null;
        }
    }
}

