/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.JavaTools;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.BlockSpring;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.FacadePluggable;
import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemFacade
extends ItemBuildCraft
implements IFacadeItem,
IPipePluggableItem {
    public static final ArrayList<ItemStack> allFacades = new ArrayList();
    public static final ArrayList<ItemStack> allHollowFacades = new ArrayList();
    public static final ArrayList<String> allFacadeIDs = new ArrayList();
    public static final ArrayList<String> blacklistedFacades = new ArrayList();
    private static final Block NULL_BLOCK = null;
    private static final ItemStack NO_MATCH = new ItemStack(NULL_BLOCK, 0, 0);
    private static final Block[] PREVIEW_FACADES = new Block[]{Blocks.field_150344_f, Blocks.field_150417_aV, Blocks.field_150359_w};
    private static int RANDOM_FACADE_ID = -1;

    public ItemFacade() {
        super((CreativeTabs)(BCCreativeTab.isPresent((String)"facades") ? BCCreativeTab.get((String)"facades") : BCCreativeTab.get((String)"main")));
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public String func_77653_i(ItemStack itemstack) {
        switch (this.getFacadeType(itemstack)) {
            case Basic: {
                FacadeState[] states = ItemFacade.getFacadeStates(itemstack);
                String displayName = states.length > 0 ? ItemFacade.getFacadeStateDisplayName(states[0]) : "CORRUPT";
                return super.func_77653_i(itemstack) + ": " + displayName;
            }
            case Phased: {
                return StringUtils.localize((String)"item.FacadePhased.name");
            }
        }
        return "";
    }

    public String func_77667_c(ItemStack itemstack) {
        return "item.Facade";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean debug) {
        for (FacadeState state : ItemFacade.getFacadeStates(stack)) {
            if (state == null || state.transparent || state.block == null || Item.func_150898_a((Block)state.block) == null) continue;
            Item.func_150898_a((Block)state.block).func_77624_a(new ItemStack(state.block, 1, state.metadata), player, list, debug);
        }
        if (this.getFacadeType(stack) == FacadeType.Phased) {
            String stateString = StringUtils.localize((String)"item.FacadePhased.state");
            FacadeState defaultState = null;
            for (FacadeState state : ItemFacade.getFacadeStates(stack)) {
                if (state.wire == null) {
                    defaultState = state;
                    continue;
                }
                list.add(String.format(stateString, state.wire.getColor(), ItemFacade.getFacadeStateDisplayName(state)));
            }
            if (defaultState != null) {
                list.add(1, String.format(StringUtils.localize((String)"item.FacadePhased.state_default"), ItemFacade.getFacadeStateDisplayName(defaultState)));
            }
        }
    }

    public static String getFacadeStateDisplayName(FacadeState state) {
        if (state.block == null) {
            return StringUtils.localize((String)"item.FacadePhased.state_transparent");
        }
        int meta = state.metadata;
        if (state.block.func_149645_b() == 31) {
            meta &= 3;
        } else if (state.block.func_149645_b() == 39 && meta > 2) {
            meta = 2;
        }
        String s = CoreProxy.proxy.getItemDisplayName(new ItemStack(state.block, 1, meta));
        if (state.hollow) {
            s = s + " (" + StringUtils.localize((String)"item.Facade.state_hollow") + ")";
        }
        return s;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        if (BuildCraftTransport.showAllFacadesCreative) {
            for (ItemStack stack : allFacades) {
                itemList.add(stack);
            }
            for (ItemStack stack : allHollowFacades) {
                itemList.add(stack);
            }
        } else {
            ArrayList<ItemStack> hollowFacades = new ArrayList<ItemStack>();
            for (Block b : PREVIEW_FACADES) {
                if (!ItemFacade.isBlockValidForFacade(b) || ItemFacade.isBlockBlacklisted(b)) continue;
                ItemStack facade = this.getFacadeForBlock(b, 0);
                itemList.add(facade);
                FacadeState state = ItemFacade.getFacadeStates(facade)[0];
                hollowFacades.add(ItemFacade.getFacade(new FacadeState(state.block, state.metadata, state.wire, true)));
            }
            if (RANDOM_FACADE_ID < 0) {
                RANDOM_FACADE_ID = BuildCraftCore.random.nextInt(allFacades.size());
            }
            itemList.add(allFacades.get(RANDOM_FACADE_ID));
            itemList.addAll(hollowFacades);
            itemList.add(allHollowFacades.get(RANDOM_FACADE_ID));
        }
    }

    public void initialize() {
        for (Object o : Block.field_149771_c) {
            Item item;
            Block b = (Block)o;
            if (!ItemFacade.isBlockValidForFacade(b) || (item = Item.func_150898_a((Block)b)) == null || ItemFacade.isBlockBlacklisted(b)) continue;
            this.registerValidFacades(b, item);
        }
    }

    private void registerValidFacades(Block block, Item item) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(16);
        try {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                for (CreativeTabs ct : item.getCreativeTabs()) {
                    block.func_149666_a(item, ct, stacks);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    stacks.add(new ItemStack(item, 1, i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ItemStack stack : stacks) {
            try {
                int i = stack.func_77960_j();
                if (block.hasTileEntity(i)) continue;
                try {
                    if (stack.func_82833_r() == null) continue;
                    if (Strings.isNullOrEmpty((String)stack.func_77977_a())) {
                    }
                }
                catch (Throwable t) {}
                continue;
                this.addFacade(stack);
            }
            catch (IndexOutOfBoundsException i) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static boolean isBlockBlacklisted(Block block) {
        String blockName = Block.field_149771_c.func_148750_c((Object)block);
        if (blockName == null) {
            return true;
        }
        for (String blacklistedBlock : blacklistedFacades) {
            if (!blockName.equals(blacklistedBlock)) continue;
            return true;
        }
        for (String blacklistedBlock : BuildCraftTransport.facadeBlacklist) {
            if (!blockName.equals(JavaTools.stripSurroundingQuotes((String)blacklistedBlock))) continue;
            return true ^ BuildCraftTransport.facadeTreatBlacklistAsWhitelist;
        }
        return false ^ BuildCraftTransport.facadeTreatBlacklistAsWhitelist;
    }

    private static boolean isBlockValidForFacade(Block block) {
        try {
            if (block.func_149704_x() != 0.0 || block.func_149665_z() != 0.0 || block.func_149706_B() != 0.0) {
                return false;
            }
            if (block.func_149753_y() != 1.0 || block.func_149669_A() != 1.0 || block.func_149693_C() != 1.0) {
                return false;
            }
            return !(block instanceof BlockSpring) && !(block instanceof BlockGenericPipe);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static FacadeState[] getFacadeStates(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return new FacadeState[0];
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!(nbt = ItemFacade.migrate(stack, nbt)).func_74764_b("states")) {
            return new FacadeState[0];
        }
        return FacadeState.readArray(nbt.func_150295_c("states", 10));
    }

    private static NBTTagCompound migrate(ItemStack stack, NBTTagCompound nbt) {
        Block block = null;
        Block blockAlt = null;
        int metadata = 0;
        PipeWire wire = null;
        if (nbt.func_74764_b("id")) {
            block = (Block)Block.field_149771_c.func_148754_a(nbt.func_74762_e("id"));
        } else if (nbt.func_74764_b("name")) {
            block = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("name"));
        }
        if (nbt.func_74764_b("name_alt")) {
            blockAlt = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("name_alt"));
        }
        if (nbt.func_74764_b("meta")) {
            metadata = nbt.func_74762_e("meta");
        }
        int metadataAlt = nbt.func_74764_b("meta_alt") ? nbt.func_74762_e("meta_alt") : stack.func_77960_j() & 0xF;
        if (nbt.func_74764_b("wire")) {
            wire = PipeWire.fromOrdinal((int)nbt.func_74762_e("wire"));
        }
        if (block != null) {
            FacadeState[] states;
            FacadeState mainState = FacadeState.create(block, metadata);
            if (blockAlt != null && wire != null) {
                FacadeState altState = FacadeState.create(blockAlt, metadataAlt, wire);
                states = new FacadeState[]{mainState, altState};
            } else {
                states = new FacadeState[]{mainState};
            }
            NBTTagCompound newNbt = ItemFacade.getFacade(states).func_77978_p();
            stack.func_77982_d(newNbt);
            return newNbt;
        }
        return nbt;
    }

    public Block[] getBlocksForFacade(ItemStack stack) {
        FacadeState[] states = ItemFacade.getFacadeStates(stack);
        Block[] blocks = new Block[states.length];
        for (int i = 0; i < states.length; ++i) {
            blocks[i] = states[i].block;
        }
        return blocks;
    }

    public int[] getMetaValuesForFacade(ItemStack stack) {
        FacadeState[] states = ItemFacade.getFacadeStates(stack);
        int[] meta = new int[states.length];
        for (int i = 0; i < states.length; ++i) {
            meta[i] = states[i].metadata;
        }
        return meta;
    }

    public FacadeType getFacadeType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return FacadeType.Basic;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("type")) {
            return FacadeType.Basic;
        }
        return FacadeType.fromOrdinal((int)nbt.func_74762_e("type"));
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public void addFacade(ItemStack itemStack) {
        Block block;
        if (itemStack.field_77994_a == 0) {
            itemStack.field_77994_a = 1;
        }
        if ((block = Block.func_149634_a((Item)itemStack.func_77973_b())) == null) {
            return;
        }
        if (!block.func_149688_o().func_76230_c()) {
            return;
        }
        String recipeId = "buildcraft:facade{" + Block.field_149771_c.func_148750_c((Object)block) + "#" + itemStack.func_77960_j() + "}";
        ItemStack facade = this.getFacadeForBlock(block, itemStack.func_77960_j());
        if (!allFacadeIDs.contains(recipeId)) {
            allFacadeIDs.add(recipeId);
            allFacades.add(facade);
            ItemStack facade6 = facade.func_77946_l();
            facade6.field_77994_a = 6;
            FacadeState state = ItemFacade.getFacadeStates(facade6)[0];
            ItemStack facadeHollow = ItemFacade.getFacade(new FacadeState(state.block, state.metadata, state.wire, true));
            allHollowFacades.add(facadeHollow);
            ItemStack facade6Hollow = facadeHollow.func_77946_l();
            facade6Hollow.field_77994_a = 6;
            if (Loader.isModLoaded((String)"BuildCraft|Silicon") && !BuildCraftTransport.facadeForceNonLaserRecipe) {
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId, 8000, facade6, new Object[]{new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack});
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":hollow", 8000, facade6Hollow, new Object[]{new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack});
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":toHollow", 160, facadeHollow, new Object[]{facade});
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":fromHollow", 160, facade, new Object[]{facadeHollow});
            } else {
                GameRegistry.addShapedRecipe((ItemStack)facade6, (Object[])new Object[]{"t ", "ts", "t ", Character.valueOf('t'), itemStack, Character.valueOf('s'), BuildCraftTransport.pipeStructureCobblestone});
                GameRegistry.addShapedRecipe((ItemStack)facade6Hollow, (Object[])new Object[]{"t ", " s", "t ", Character.valueOf('t'), itemStack, Character.valueOf('s'), BuildCraftTransport.pipeStructureCobblestone});
            }
        }
    }

    public static void blacklistFacade(String blockName) {
        if (!blacklistedFacades.contains(blockName)) {
            blacklistedFacades.add(blockName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public ItemStack getFacadeForBlock(Block block, int metadata) {
        return ItemFacade.getFacade(FacadeState.create(block, metadata));
    }

    public static ItemStack getAdvancedFacade(PipeWire wire, Block block, int metadata, Block blockAlt, int metaDataAlt) {
        return ItemFacade.getFacade(FacadeState.create(block, metadata), FacadeState.create(blockAlt, metaDataAlt, wire));
    }

    public static ItemStack getFacade(FacadeState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        boolean basic = states.length == 1 && states[0].wire == null;
        ItemStack stack = new ItemStack((Item)BuildCraftTransport.facadeItem, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("type", (byte)(basic ? FacadeType.Basic : FacadeType.Phased).ordinal());
        nbt.func_74782_a("states", (NBTBase)FacadeState.writeArray(states));
        stack.func_77982_d(nbt);
        return stack;
    }

    public PipePluggable createPipePluggable(IPipe pipe, ForgeDirection side, ItemStack stack) {
        return new FacadePluggable(ItemFacade.getFacadeStates(stack));
    }

    public class FacadeRecipe
    implements IRecipe {
        public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            return facade != null && facade[0] != null && ((Block[])facade[0]).length == 1;
        }

        public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            if (facade == null || ((Block[])facade[0]).length != 1) {
                return null;
            }
            Block block = ((Block[])facade[0])[0];
            ItemStack originalFacade = (ItemStack)facade[1];
            if (block == null) {
                return null;
            }
            return this.getNextFacadeItemStack(block, originalFacade);
        }

        private Object[] getFacadeBlockFromCraftingGrid(InventoryCrafting inventorycrafting) {
            ItemStack slotmatch = null;
            int countOfItems = 0;
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                ItemStack slot = inventorycrafting.func_70301_a(i);
                if (slot != null && slot.func_77973_b() == ItemFacade.this && slotmatch == null) {
                    slotmatch = slot;
                    ++countOfItems;
                } else if (slot != null) {
                    slotmatch = NO_MATCH;
                }
                if (countOfItems <= true) continue;
                return null;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                return new Object[]{ItemFacade.this.getBlocksForFacade(slotmatch), slotmatch};
            }
            return null;
        }

        private ItemStack getNextFacadeItemStack(Block block, ItemStack originalFacade) {
            int blockMeta;
            int stackMeta = blockMeta = ItemFacade.this.getMetaValuesForFacade(originalFacade)[0];
            switch (block.func_149645_b()) {
                case 31: {
                    if ((blockMeta & 0xC) == 0) {
                        stackMeta = blockMeta & 3 | 4;
                        break;
                    }
                    if ((blockMeta & 8) == 0) {
                        stackMeta = blockMeta & 3 | 8;
                        break;
                    }
                    if ((blockMeta & 4) != 0) break;
                    stackMeta = blockMeta & 3;
                    break;
                }
                case 39: {
                    if (blockMeta >= 2 && blockMeta < 4) {
                        stackMeta = blockMeta + 1;
                        break;
                    }
                    if (blockMeta != 4) break;
                    stackMeta = 2;
                }
            }
            return ItemFacade.this.getFacadeForBlock(block, stackMeta);
        }

        public int func_77570_a() {
            return 1;
        }

        public ItemStack func_77571_b() {
            return null;
        }
    }

    public static class FacadeState {
        public final Block block;
        public final int metadata;
        public final boolean transparent;
        public final boolean hollow;
        public final PipeWire wire;

        public FacadeState(Block block, int metadata, PipeWire wire) {
            this.block = block;
            this.metadata = metadata;
            this.wire = wire;
            this.transparent = false;
            this.hollow = false;
        }

        public FacadeState(Block block, int metadata, PipeWire wire, boolean hollow) {
            this.block = block;
            this.metadata = metadata;
            this.wire = wire;
            this.transparent = false;
            this.hollow = hollow;
        }

        public FacadeState(NBTTagCompound nbt) {
            this.block = nbt.func_74764_b("block") ? (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("block")) : null;
            this.metadata = nbt.func_74771_c("metadata");
            this.wire = nbt.func_74764_b("wire") ? PipeWire.fromOrdinal((int)nbt.func_74771_c("wire")) : null;
            this.transparent = nbt.func_74764_b("transparent") && nbt.func_74767_n("transparent");
            this.hollow = nbt.func_74764_b("hollow") && nbt.func_74767_n("hollow");
        }

        private FacadeState(PipeWire wire) {
            this.block = null;
            this.metadata = 0;
            this.wire = wire;
            this.transparent = true;
            this.hollow = false;
        }

        public static FacadeState create(Block block, int metadata) {
            return FacadeState.create(block, metadata, null);
        }

        public static FacadeState create(Block block, int metadata, PipeWire wire) {
            return new FacadeState(block, metadata, wire);
        }

        public static FacadeState createTransparent(PipeWire wire) {
            return new FacadeState(wire);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            if (this.block != null) {
                nbt.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
            }
            nbt.func_74774_a("metadata", (byte)this.metadata);
            if (this.wire != null) {
                nbt.func_74774_a("wire", (byte)this.wire.ordinal());
            }
            nbt.func_74757_a("transparent", this.transparent);
            nbt.func_74757_a("hollow", this.hollow);
        }

        public static NBTTagList writeArray(FacadeState[] states) {
            if (states == null) {
                return null;
            }
            NBTTagList list = new NBTTagList();
            for (FacadeState state : states) {
                NBTTagCompound stateNBT = new NBTTagCompound();
                state.writeToNBT(stateNBT);
                list.func_74742_a((NBTBase)stateNBT);
            }
            return list;
        }

        public static FacadeState[] readArray(NBTTagList list) {
            if (list == null) {
                return null;
            }
            int length = list.func_74745_c();
            FacadeState[] states = new FacadeState[length];
            for (int i = 0; i < length; ++i) {
                states[i] = new FacadeState(list.func_150305_b(i));
            }
            return states;
        }
    }
}

