/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.core.IMCHandler;
import buildcraft.transport.ItemFacade;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class IMCHandlerTransport
extends IMCHandler {
    public void processIMCEvent(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        if (m.key.equals("add-facade")) {
            IMCHandlerTransport.processAddFacadeIMC(event, m);
        } else if (m.key.equals("blacklist-facade")) {
            IMCHandlerTransport.processBlacklistFacadeIMC(event, m);
        } else if (m.key.equals("add-gate-expansion-recipe")) {
            IMCHandlerTransport.processGateExpansionRecipeAddIMC(event, m);
        }
    }

    public static void processGateExpansionRecipeAddIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        boolean failed = false;
        if (!msg.isNBTMessage()) {
            failed = true;
        } else {
            NBTTagCompound recipe = msg.getNBTValue();
            if (!(recipe.func_74764_b("id") && recipe.func_74764_b("expansion") && recipe.func_74764_b("input"))) {
                failed = true;
            } else {
                IGateExpansion exp = GateExpansions.getExpansion((String)recipe.func_74779_i("expansion"));
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)recipe.func_74775_l("input"));
                if (exp == null || is == null) {
                    failed = true;
                } else {
                    GateExpansions.registerExpansion((IGateExpansion)exp, (ItemStack)is);
                }
            }
        }
        if (failed) {
            BCLog.logger.warn("Received invalid gate expansion recipe IMC message from mod %s!", new Object[]{msg.getSender()});
        }
    }

    public static void processAddFacadeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Splitter splitter = Splitter.on((String)"@").trimResults();
                String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
                if (array.length != 2) {
                    BCLog.logger.info(String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    String blockName = array[0];
                    Integer metaId = Ints.tryParse((String)array[1]);
                    if (Strings.isNullOrEmpty((String)blockName) || metaId == null) {
                        BCLog.logger.info(String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                    } else {
                        Block block = (Block)Block.field_149771_c.func_82594_a(blockName);
                        BuildCraftTransport.facadeItem.addFacade(new ItemStack(block, 1, metaId.intValue()));
                    }
                }
            } else if (m.isItemStackMessage()) {
                ItemStack modItemStack = m.getItemStackValue();
                BuildCraftTransport.facadeItem.addFacade(modItemStack);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processBlacklistFacadeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage message) {
        try {
            if (message.isItemStackMessage()) {
                ItemStack modItemStack = message.getItemStackValue();
                Block block = Block.func_149634_a((Item)modItemStack.func_77973_b());
                if (block != null) {
                    String blockName = Block.field_149771_c.func_148750_c((Object)block);
                    ItemFacade.blacklistFacade(blockName);
                }
            } else {
                BCLog.logger.info(String.format("Invalid blacklist-facade message from mod %s. Send an ItemStackMessage instead.", message.getSender()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

