/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IFacadePluggable;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.render.FacadeRenderHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class FacadePluggable
extends PipePluggable
implements IFacadePluggable {
    public ItemFacade.FacadeState[] states;
    private ItemFacade.FacadeState activeState;
    private IPipeTile pipe;
    private Block block;
    private int meta;
    private boolean transparent;
    private boolean renderAsHollow;

    public FacadePluggable(ItemFacade.FacadeState[] states) {
        this.states = states;
        this.prepareStates();
    }

    public FacadePluggable() {
    }

    public void invalidate() {
        this.pipe = null;
    }

    public void validate(IPipeTile pipe, ForgeDirection direction) {
        this.pipe = pipe;
    }

    public boolean requiresRenderUpdate(PipePluggable o) {
        FacadePluggable other = (FacadePluggable)o;
        return other.block != this.block || other.meta != this.meta || other.transparent != this.transparent || other.renderAsHollow != this.renderAsHollow;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.states != null) {
            nbt.func_74782_a("states", (NBTBase)ItemFacade.FacadeState.writeArray(this.states));
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("states")) {
            this.states = ItemFacade.FacadeState.readArray(nbt.func_150295_c("states", 10));
        }
    }

    public ItemStack[] getDropItems(IPipeTile pipe) {
        if (this.states != null) {
            return new ItemStack[]{ItemFacade.getFacade(this.states)};
        }
        return new ItemStack[]{ItemFacade.getFacade(new ItemFacade.FacadeState(this.getCurrentBlock(), this.getCurrentMetadata(), null, this.isHollow()))};
    }

    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return !this.isHollow();
    }

    public Block getCurrentBlock() {
        this.prepareStates();
        return this.activeState == null ? this.block : this.activeState.block;
    }

    public int getCurrentMetadata() {
        this.prepareStates();
        return this.activeState == null ? this.meta : this.activeState.metadata;
    }

    public boolean isTransparent() {
        this.prepareStates();
        return this.activeState == null ? this.transparent : this.activeState.transparent;
    }

    public boolean isHollow() {
        this.prepareStates();
        return this.activeState == null ? this.renderAsHollow : this.activeState.hollow;
    }

    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.0f;
        bounds[0][1] = 1.0f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.125f;
        bounds[2][0] = 0.0f;
        bounds[2][1] = 1.0f;
        MatrixTranformations.transform((float[][])bounds, (ForgeDirection)side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    public boolean isSolidOnSide(IPipeTile pipe, ForgeDirection direction) {
        return !this.isHollow();
    }

    public IPipePluggableRenderer getRenderer() {
        return FacadePluggableRenderer.INSTANCE;
    }

    public void writeData(ByteBuf data) {
        this.prepareStates();
        if (this.activeState == null || this.activeState.block == null) {
            data.writeShort(0);
        } else {
            data.writeShort(Block.func_149682_b((Block)this.activeState.block));
        }
        data.writeByte((this.activeState != null && this.activeState.transparent ? 128 : 0) | (this.activeState != null && this.activeState.hollow ? 64 : 0) | (this.activeState == null ? 0 : this.activeState.metadata));
    }

    public void readData(ByteBuf data) {
        int blockId = data.readUnsignedShort();
        this.block = blockId > 0 ? Block.func_149729_e((int)blockId) : null;
        short flags = data.readUnsignedByte();
        this.meta = flags & 0xF;
        this.transparent = (flags & 0x80) != 0;
        this.renderAsHollow = (flags & 0x40) != 0;
    }

    private void prepareStates() {
        if (this.states != null && this.states.length > 1) {
            if (this.pipe == null || this.pipe.getPipe() == null) {
                this.activeState = this.states[0];
                return;
            }
            IPipe p = this.pipe.getPipe();
            int defaultStateId = -1;
            int activeStateId = -1;
            for (int i = 0; i < this.states.length; ++i) {
                ItemFacade.FacadeState state = this.states[i];
                if (state.wire == null) {
                    defaultStateId = i;
                    continue;
                }
                if (!p.isWireActive(state.wire)) continue;
                activeStateId = i;
                break;
            }
            this.activeState = activeStateId < 0 ? (defaultStateId < 0 ? this.states[0] : this.states[defaultStateId]) : this.states[activeStateId];
        } else if (this.activeState == null) {
            this.activeState = this.states != null && this.states.length > 0 ? this.states[0] : null;
        }
    }

    public static final class FacadePluggableRenderer
    implements IPipePluggableRenderer {
        public static final IPipePluggableRenderer INSTANCE = new FacadePluggableRenderer();

        private FacadePluggableRenderer() {
        }

        public void renderPluggable(RenderBlocks renderblocks, IPipe pipe, ForgeDirection side, PipePluggable pipePluggable, ITextureStates blockStateMachine, int renderPass, int x, int y, int z) {
            FacadeRenderHelper.pipeFacadeRenderer(renderblocks, blockStateMachine, pipe.getTile(), renderPass, x, y, z, side, (IFacadePluggable)pipePluggable);
        }
    }
}

