/*
 * Decompiled with CFR 0.152.
 */
package openmods.integration.modules;

import buildcraft.api.transport.IPipeTile;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.integration.Conditions;
import openmods.integration.IntegrationModule;
import openmods.inventory.legacy.CustomSinks;

public class BuildCraftPipes
extends IntegrationModule {
    private static BuildCraftAccess access = new Dummy();

    public BuildCraftPipes() {
        super(Conditions.classExists("buildcraft.api.transport.IPipeTile"));
    }

    public static BuildCraftAccess access() {
        return access;
    }

    @Override
    public void load() {
        access = new Live();
        CustomSinks.registerCustomSink(new CustomSinks.ICustomSinkProvider(){

            @Override
            public CustomSinks.ICustomSink create(final TileEntity te) {
                if (!access.isPipe(te)) {
                    return null;
                }
                return new CustomSinks.ICustomSink(){

                    @Override
                    public int accept(ItemStack stack, boolean doInsert, ForgeDirection direction) {
                        return access.tryAcceptIntoPipe(te, stack, doInsert, direction);
                    }
                };
            }
        });
    }

    @Override
    public String name() {
        return "BuildCraft pipes";
    }

    private static class Live
    implements BuildCraftAccess {
        private Live() {
        }

        @Override
        public int tryAcceptIntoPipe(TileEntity possiblePipe, ItemStack nextStack, boolean doInsert, ForgeDirection direction) {
            if (possiblePipe instanceof IPipeTile) {
                return ((IPipeTile)possiblePipe).injectItem(nextStack, doInsert, direction.getOpposite());
            }
            return 0;
        }

        @Override
        public boolean isPipe(TileEntity tile) {
            return tile instanceof IPipeTile;
        }
    }

    private static class Dummy
    implements BuildCraftAccess {
        private Dummy() {
        }

        @Override
        public int tryAcceptIntoPipe(TileEntity possiblePipe, ItemStack nextStack, boolean doInsert, ForgeDirection direction) {
            return 0;
        }

        @Override
        public boolean isPipe(TileEntity tile) {
            return false;
        }
    }

    public static interface BuildCraftAccess {
        public int tryAcceptIntoPipe(TileEntity var1, ItemStack var2, boolean var3, ForgeDirection var4);

        public boolean isPipe(TileEntity var1);
    }
}

