/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.game;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import openmods.config.BlockInstances;
import openmods.config.ItemInstances;
import openmods.config.game.AbstractFeatureManager;
import openmods.config.game.RegisterBlock;
import openmods.config.game.RegisterItem;

public class ConfigurableFeatureManager
extends AbstractFeatureManager {
    private final Table<String, String, CustomFeatureRule> customRules = HashBasedTable.create();
    private final Table<String, String, FeatureEntry> features = HashBasedTable.create();

    public void collectFromItems(Class<? extends ItemInstances> itemContainer) {
        for (Field f : itemContainer.getFields()) {
            RegisterItem item = f.getAnnotation(RegisterItem.class);
            if (item == null) continue;
            this.features.put((Object)"items", (Object)item.name(), (Object)new FeatureEntry(item.isEnabled(), item.isConfigurable()));
        }
    }

    public void collectFromBlocks(Class<? extends BlockInstances> blockContainer) {
        for (Field f : blockContainer.getFields()) {
            RegisterBlock item = f.getAnnotation(RegisterBlock.class);
            if (item == null) continue;
            this.features.put((Object)"blocks", (Object)item.name(), (Object)new FeatureEntry(item.isEnabled(), item.isConfigurable()));
        }
    }

    public Table<String, String, Property> loadFromConfiguration(Configuration config) {
        HashBasedTable properties = HashBasedTable.create();
        for (Table.Cell cell : this.features.cellSet()) {
            FeatureEntry entry = (FeatureEntry)cell.getValue();
            if (!entry.isConfigurable) continue;
            String categoryName = (String)cell.getRowKey();
            String featureName = (String)cell.getColumnKey();
            Property prop = config.get(categoryName, featureName, entry.isEnabled);
            properties.put((Object)categoryName, (Object)featureName, (Object)prop);
            if (!prop.wasRead()) continue;
            if (!prop.isBooleanValue()) {
                prop.set(entry.isEnabled);
                continue;
            }
            entry.isEnabled = prop.getBoolean(entry.isEnabled);
        }
        return ImmutableTable.copyOf((Table)properties);
    }

    @Override
    public boolean isEnabled(String category, String name) {
        FeatureEntry result = (FeatureEntry)this.features.get((Object)category, (Object)name);
        if (result == null) {
            return false;
        }
        CustomFeatureRule rule = (CustomFeatureRule)this.customRules.get((Object)category, (Object)name);
        return rule != null ? rule.isEnabled(result.isEnabled) : result.isEnabled;
    }

    public void addCustomRule(String category, String name, CustomFeatureRule rule) {
        CustomFeatureRule prev = (CustomFeatureRule)this.customRules.put((Object)category, (Object)name, (Object)rule);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate rule on %s:%s", (Object[])new Object[]{category, name});
    }

    @Override
    public Set<String> getCategories() {
        return this.features.rowKeySet();
    }

    @Override
    public Set<String> getFeaturesInCategory(String category) {
        return this.features.row((Object)category).keySet();
    }

    public static interface CustomFeatureRule {
        public boolean isEnabled(boolean var1);
    }

    private static class FeatureEntry {
        public boolean isEnabled;
        public final boolean isConfigurable;

        private FeatureEntry(boolean isEnabled, boolean isConfigurable) {
            this.isEnabled = isEnabled;
            this.isConfigurable = isConfigurable;
        }
    }
}

