/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.Fluid;
import openblocks.OpenBlocks;
import openblocks.common.LiquidXpUtils;
import openblocks.common.entity.EntityXPOrbNoFly;
import openmods.OpenMods;
import openmods.api.IAddAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.liquids.GenericTank;
import openmods.sync.SyncableBoolean;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityXPShower
extends SyncedTileEntity
implements INeighbourAwareTile,
IAddAwareTile {
    private static final int DRAIN_PER_CYCLE = 50;
    private GenericTank bufferTank = new GenericTank(1000, new Fluid[]{OpenBlocks.Fluids.xpJuice});
    private SyncableBoolean isOn;
    private SyncableBoolean particleSpawnerActive;
    private int particleSpawnTimer = 0;

    protected void createSyncedFields() {
        this.isOn = new SyncableBoolean();
        this.particleSpawnerActive = new SyncableBoolean();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.trySpawnXpOrbs();
        } else {
            this.trySpawnParticles();
        }
    }

    private void trySpawnXpOrbs() {
        boolean hasSpawnedParticle = false;
        if (this.isOn.get() && OpenMods.proxy.getTicks(this.field_145850_b) % 3L == 0L) {
            int xpInTank;
            int drainable;
            this.bufferTank.fillFromSide(50, this.field_145850_b, this.getPosition(), this.getOrientation().north());
            int amountInTank = this.bufferTank.getFluidAmount();
            if (amountInTank > 0 && (drainable = LiquidXpUtils.xpToLiquidRatio(xpInTank = LiquidXpUtils.liquidToXpRatio(amountInTank))) > 0) {
                this.bufferTank.drain(drainable, true);
                while (xpInTank > 0) {
                    hasSpawnedParticle = true;
                    int xpAmount = EntityXPOrb.func_70527_a((int)xpInTank);
                    xpInTank -= xpAmount;
                    this.field_145850_b.func_72838_d((Entity)new EntityXPOrbNoFly(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, xpAmount));
                }
            }
        }
        this.particleSpawnerActive.set(hasSpawnedParticle);
        this.sync();
    }

    private void trySpawnParticles() {
        int particleLevel = OpenBlocks.proxy.getParticleSettings();
        if (particleLevel == 0 || particleLevel == 1 && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            int n = this.particleSpawnTimer = this.particleSpawnerActive.get() ? 10 : this.particleSpawnTimer - 1;
            if (this.particleSpawnTimer > 0) {
                Vec3 vec = Vec3.func_72443_a((double)((this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.05), (double)0.0, (double)((this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.05));
                OpenBlocks.proxy.spawnLiquidSpray(this.field_145850_b, OpenBlocks.Fluids.xpJuice, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.4, (double)this.field_145849_e + 0.5, 0.4f, 0.7f, vec);
            }
        }
    }

    public void onAdded() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateState();
        }
    }

    public void onNeighbourChanged(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.updateState();
        }
    }

    public void updateState() {
        boolean isPowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.isOn.set(!isPowered);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.bufferTank.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.bufferTank.writeToNBT(nbt);
    }
}

