/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumMap;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.MusePacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public class PacketSender {
    private static EnumMap<Side, FMLEmbeddedChannel> channels = MusePacketHandler.channels;

    public static Packet getPacketFrom(MusePacket message) {
        return channels.get(Side.SERVER).generatePacketFrom((Object)message);
    }

    public static void sendToAll(MusePacket message) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public static void sendTo(MusePacket message, EntityPlayerMP player) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public static void sendToAllAround(MusePacket message, NetworkRegistry.TargetPoint point) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public static void sendToDimension(MusePacket message, int dimensionId) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new Integer(dimensionId));
        channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public static void sendToServer(MusePacket message) {
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeOutbound(new Object[]{message});
    }

    public static void sendToAllAround(MusePacket packet, TileEntity entity, double d) {
        PacketSender.sendToAllAround(packet, new NetworkRegistry.TargetPoint(entity.func_145831_w().field_73011_w.field_76574_g, (double)entity.field_145851_c, (double)entity.field_145848_d, (double)entity.field_145849_e, d));
    }

    public static void sendToAllAround(MusePacket packet, Entity entity, double d) {
        PacketSender.sendToAllAround(packet, new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, d));
    }
}

