/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.tiles;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridException;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.blocks.IIBlocks;
import unwrittenfun.minecraft.immersiveintegration.tiles.IWireConnector;
import unwrittenfun.minecraft.immersiveintegration.wires.IIWires;

public class TileMETransformer
extends TileEntityImmersiveConnectable
implements IGridHost,
IGridBlock,
IWireConnector {
    public IGridNode theGridNode;
    public IGridConnection theConnection;
    private boolean loaded = false;

    public void func_145845_h() {
        if (!this.loaded && this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            Set connections;
            this.loaded = true;
            this.createAELink();
            if (this.canConnect() && (connections = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC((Object)this))) != null && connections.iterator().hasNext()) {
                ImmersiveNetHandler.Connection connection = (ImmersiveNetHandler.Connection)connections.iterator().next();
                ChunkCoordinates opposite = connection.end;
                if (opposite.equals((Object)Utils.toCC((Object)this))) {
                    return;
                }
                this.connectTo(opposite.field_71574_a, opposite.field_71572_b, opposite.field_71573_c);
            }
        }
    }

    public double getIdlePowerUsage() {
        return this.canConnect() ? 0.0 : (double)ImmersiveIntegration.cfg.meTransformerPowerDrain;
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }

    public boolean isWorldAccessible() {
        return true;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AEColor getGridColor() {
        return AEColor.Transparent;
    }

    public void onGridNotification(GridNotification notification) {
    }

    public void setNetworkStatus(IGrid grid, int channelsInUse) {
    }

    public EnumSet<ForgeDirection> getConnectableSides() {
        return this.canConnect() ? EnumSet.of(ForgeDirection.DOWN) : EnumSet.range(ForgeDirection.DOWN, ForgeDirection.EAST);
    }

    public IGridHost getMachine() {
        return this;
    }

    public void gridChanged() {
    }

    public ItemStack getMachineRepresentation() {
        return this.canConnect() ? null : new ItemStack(IIBlocks.meTransformer);
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        if (this.theGridNode == null) {
            this.createAELink();
        }
        return this.theGridNode;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    public void createAELink() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.theGridNode == null) {
                this.theGridNode = AEApi.instance().createGridNode((IGridBlock)this);
            }
            this.theGridNode.updateState();
        }
    }

    public void destroyAELink() {
        if (this.theGridNode != null) {
            this.theGridNode.destroy();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.destroyAELink();
        }
    }

    public void onChunkUnload() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.destroyAELink();
        }
    }

    public boolean canConnect() {
        return (this.func_145832_p() & 8) == 8;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        return cableType == IIWires.fluixWire && this.limitType == null;
    }

    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return false;
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        if (this.theConnection != null && !this.field_145850_b.field_72995_K) {
            this.theConnection.destroy();
            this.theConnection = null;
        }
        super.removeCable(connection);
    }

    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        return Vec3.func_72443_a((double)0.5, (double)1.5, (double)0.5);
    }

    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return Vec3.func_72443_a((double)0.5, (double)1.4, (double)0.5);
    }

    @Override
    public void connectTo(int x, int y, int z) {
        TileEntity teOpposite = this.field_145850_b.func_147438_o(x, y, z);
        if (teOpposite instanceof IGridHost) {
            IGridNode nodeA = ((IGridHost)teOpposite).getGridNode(ForgeDirection.UNKNOWN);
            IGridNode nodeB = this.getGridNode(ForgeDirection.UNKNOWN);
            try {
                if (this.theConnection != null) {
                    this.theConnection.destroy();
                    this.theConnection = null;
                }
                this.theConnection = AEApi.instance().createGridConnection(nodeA, nodeB);
            }
            catch (FailedConnection failedConnection) {
                if (ImmersiveIntegration.cfg.verboseLogging) {
                    ImmersiveIntegration.log.info(failedConnection.getMessage());
                }
            }
            catch (GridException gridException) {
                // empty catch block
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.theGridNode == null) {
            this.createAELink();
        }
    }
}

