/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.blocks;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.util.AEColor;
import blusunrize.immersiveengineering.common.IEContent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockAEDecoration;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockExtendablePost;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockExtendedPost;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockInductionCharger;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockIndustrialCokeOven;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockItemRobin;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockMEDenseTransformer;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockMEDenseWireConnector;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockMETransformer;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockMEWireConnector;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockRedstoneWireConnector;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockSteelDecoration;
import unwrittenfun.minecraft.immersiveintegration.blocks.BlockSteelTrapdoor;
import unwrittenfun.minecraft.immersiveintegration.items.IIItems;
import unwrittenfun.minecraft.immersiveintegration.items.blocks.ItemBlockAEDecoration;
import unwrittenfun.minecraft.immersiveintegration.items.blocks.ItemBlockExtendedPost;
import unwrittenfun.minecraft.immersiveintegration.items.blocks.ItemBlockInductionCharger;
import unwrittenfun.minecraft.immersiveintegration.items.blocks.ItemBlockMETransformer;
import unwrittenfun.minecraft.immersiveintegration.items.blocks.ItemBlockSteelDecoration;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileExtendedPost;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileInductionChargerHV;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileInductionChargerLV;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileInductionChargerMV;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileIndustrialCokeOven;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileItemRobin;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileMEDenseTransformer;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileMEDenseWireConnector;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileMETransformer;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileMEWireConnector;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileRedstoneWireConnector;

public class IIBlocks {
    public static final String ME_WIRE_CONNECTOR_KEY = "meWireConnector";
    public static final String ME_DENSE_CONNECTOR_KEY = "meDenseWireConnector";
    public static final String EXTENDED_POST_KEY = "extendedPost";
    public static final String EXTENDABLE_POST_KEY = "extendablePost";
    public static final String STEEL_TRAPDOOR = "steelTrapdoor";
    public static final String REDSTONE_WIRE_CONNECTOR_KEY = "redstoneWireConnector";
    public static final String INDUSTRIAL_COKE_OVEN = "industrialCokeOven";
    public static final String ITEM_ROBIN_KEY = "itemRobin";
    public static final String ME_TRANSFORMER_KEY = "meTransformer";
    public static final String ME_DENSE_TRANSFORMER_KEY = "meDenseTransformer";
    public static final String STEEL_BLOCKS_KEY = "steelDecoration";
    public static final String AE_DECORATIONS_KEY = "aeDecoration";
    public static final String INDUCTION_CHARGER_KEY = "inductionCharger";
    public static final String WALL_CONNECTOR_KEY = "wallConnector";
    public static final String[] STEEL_BLOCKS_KEYS = new String[]{"OvenWall", "OvenWallHeated", "OvenWallPort"};
    public static final String[] AE_DECORATION_KEYS = new String[]{"FluixCoil", "DenseCoil"};
    public static Block meWireConnector;
    public static Block meDenseWireConnector;
    public static Block meTransformer;
    public static Block meDenseTransformer;
    public static Block redstoneWireConnector;
    public static Block wallConnector;
    public static Block extendedPost;
    public static Block extendablePost;
    public static Block steelTrapdoor;
    public static Block aeDecoration;
    public static Block industrialCokeOven;
    public static Block itemRobin;
    public static Block steelDecoration;
    public static Block inductionCharger;

    public static void registerBlocks() {
        extendablePost = IIBlocks.registerBlock(BlockExtendablePost.class, EXTENDABLE_POST_KEY);
        steelTrapdoor = IIBlocks.registerBlock(BlockSteelTrapdoor.class, STEEL_TRAPDOOR);
        steelDecoration = IIBlocks.registerBlock(BlockSteelDecoration.class, ItemBlockSteelDecoration.class, STEEL_BLOCKS_KEY);
        extendedPost = IIBlocks.registerBlock(BlockExtendedPost.class, ItemBlockExtendedPost.class, EXTENDED_POST_KEY, TileExtendedPost.class);
        industrialCokeOven = IIBlocks.registerBlock(BlockIndustrialCokeOven.class, INDUSTRIAL_COKE_OVEN, TileIndustrialCokeOven.class);
        itemRobin = IIBlocks.registerBlock(BlockItemRobin.class, ITEM_ROBIN_KEY, TileItemRobin.class);
        inductionCharger = IIBlocks.registerBlock(BlockInductionCharger.class, ItemBlockInductionCharger.class, INDUCTION_CHARGER_KEY);
        redstoneWireConnector = IIBlocks.registerBlock(BlockRedstoneWireConnector.class, REDSTONE_WIRE_CONNECTOR_KEY, TileRedstoneWireConnector.class);
        GameRegistry.registerTileEntity(TileInductionChargerLV.class, (String)"immersiveintegration:inductionChargerLVTile");
        GameRegistry.registerTileEntity(TileInductionChargerMV.class, (String)"immersiveintegration:inductionChargerMVTile");
        GameRegistry.registerTileEntity(TileInductionChargerHV.class, (String)"immersiveintegration:inductionChargerHVTile");
        if (ImmersiveIntegration.cfg.enableAE) {
            IIBlocks.registerAE2(false);
        }
    }

    private static void registerAE2(boolean recipes) {
        if (recipes) {
            IDefinitions ae = AEApi.instance().definitions();
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(meWireConnector, 4), new Object[]{" c ", "fsf", "sfs", Character.valueOf('c'), ae.parts().cableGlass().stack(AEColor.Transparent, 1), Character.valueOf('f'), "dustFluix", Character.valueOf('s'), ae.blocks().skyStone().maybeBlock().get()}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(meDenseWireConnector, 2), new Object[]{" d ", "rcr", "cgc", Character.valueOf('d'), ae.parts().cableDense().stack(AEColor.Transparent, 1), Character.valueOf('r'), "dustRedstone", Character.valueOf('c'), meWireConnector, Character.valueOf('g'), "dustGlowstone"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(aeDecoration, 1, 0), new Object[]{"www", "wiw", "www", Character.valueOf('w'), new ItemStack(IIItems.aeWireCoil, 1, 0), Character.valueOf('i'), "ingotIron"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(aeDecoration, 1, 1), new Object[]{"www", "wiw", "www", Character.valueOf('w'), new ItemStack(IIItems.aeWireCoil, 1, 1), Character.valueOf('i'), "ingotIron"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(meTransformer), new Object[]{" w ", "ibi", "iii", Character.valueOf('w'), meWireConnector, Character.valueOf('b'), new ItemStack(aeDecoration, 1, 0), Character.valueOf('i'), "ingotIron"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(meDenseTransformer), new Object[]{" w ", "ibi", "iii", Character.valueOf('w'), meDenseWireConnector, Character.valueOf('b'), new ItemStack(aeDecoration, 1, 1), Character.valueOf('i'), "ingotIron"}));
        } else {
            meWireConnector = IIBlocks.registerBlock(BlockMEWireConnector.class, ME_WIRE_CONNECTOR_KEY, TileMEWireConnector.class);
            meDenseWireConnector = IIBlocks.registerBlock(BlockMEDenseWireConnector.class, ME_DENSE_CONNECTOR_KEY, TileMEDenseWireConnector.class);
            meTransformer = IIBlocks.registerBlock(BlockMETransformer.class, ItemBlockMETransformer.class, ME_TRANSFORMER_KEY, TileMETransformer.class);
            meDenseTransformer = IIBlocks.registerBlock(BlockMEDenseTransformer.class, ItemBlockMETransformer.class, ME_DENSE_TRANSFORMER_KEY, TileMEDenseTransformer.class);
            aeDecoration = IIBlocks.registerBlock(BlockAEDecoration.class, ItemBlockAEDecoration.class, AE_DECORATIONS_KEY);
        }
    }

    public static void registerRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)IEContent.blockWoodenDecoration, 2, 1), new Object[]{extendedPost}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(extendablePost, new Object[]{new ItemStack((Block)IEContent.blockWoodenDecoration, 1, 1), Blocks.field_150417_aV}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(steelTrapdoor, 2), (Object[])new Object[]{"sss", "sss", Character.valueOf('s'), new ItemStack((Block)IEContent.blockMetalDecoration, 1, 1)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(redstoneWireConnector, 8), new Object[]{"beb", " r ", "beb", Character.valueOf('b'), "blockRedstone", Character.valueOf('e'), "ingotElectrum", Character.valueOf('r'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(steelDecoration, 8, 0), new Object[]{"ibi", "sbs", "ibi", Character.valueOf('s'), new ItemStack((Item)IEContent.itemMaterial, 1, 12), Character.valueOf('b'), Items.field_151133_ar, Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(steelDecoration, 8, 1), new Object[]{"ibi", "sbs", "ibi", Character.valueOf('s'), new ItemStack((Item)IEContent.itemMaterial, 1, 12), Character.valueOf('b'), Items.field_151129_at, Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(steelDecoration, 4, 2), new Object[]{"ibi", "isi", "ibi", Character.valueOf('s'), new ItemStack((Item)IEContent.itemMaterial, 1, 12), Character.valueOf('b'), Items.field_151133_ar, Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemRobin, new Object[]{" r ", "scs", " r ", Character.valueOf('s'), new ItemStack((Item)IEContent.itemMaterial, 1, 12), Character.valueOf('r'), "dustRedstone", Character.valueOf('c'), new ItemStack((Block)IEContent.blockWoodenDevice, 1, 4)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(inductionCharger, 1, 0), new Object[]{"scs", "wew", Character.valueOf('s'), "slabTreatedWood", Character.valueOf('c'), new ItemStack((Block)IEContent.blockStorage, 1, 8), Character.valueOf('w'), "plankTreatedWood", Character.valueOf('e'), new ItemStack((Block)IEContent.blockMetalDevice, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(inductionCharger, 1, 1), new Object[]{"scs", "wew", Character.valueOf('s'), "slabTreatedWood", Character.valueOf('c'), new ItemStack((Block)IEContent.blockStorage, 1, 9), Character.valueOf('w'), "plankTreatedWood", Character.valueOf('e'), new ItemStack((Block)IEContent.blockMetalDevice, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(inductionCharger, 1, 2), new Object[]{"scs", "wew", Character.valueOf('s'), "slabTreatedWood", Character.valueOf('c'), new ItemStack((Block)IEContent.blockStorage, 1, 10), Character.valueOf('w'), "plankTreatedWood", Character.valueOf('e'), new ItemStack((Block)IEContent.blockMetalDevice, 1, 7)}));
        if (ImmersiveIntegration.cfg.enableAE) {
            IIBlocks.registerAE2(true);
        }
    }

    public static Block registerBlock(Class<? extends Block> blockClass, Class<? extends ItemBlock> itemClass, String key, Class<? extends TileEntity> tileClass) {
        try {
            Block block = blockClass.getConstructor(String.class).newInstance("immersiveintegration:" + key);
            if (itemClass == null) {
                GameRegistry.registerBlock((Block)block, (String)key);
            } else {
                GameRegistry.registerBlock((Block)block, itemClass, (String)key);
            }
            if (tileClass != null) {
                GameRegistry.registerTileEntity(tileClass, (String)("immersiveintegration:" + key + "Tile"));
            }
            return block;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ImmersiveIntegration.log.error("Something went horribly wrong instantiating a block for " + blockClass.getName());
            e.printStackTrace();
            ImmersiveIntegration.log.error("Report this to UnwrittenFun. Do NOT ignore. Exiting Java.");
            FMLCommonHandler.instance().exitJava(0, false);
            return null;
        }
    }

    public static Block registerBlock(Class<? extends Block> blockClass, String key, Class<? extends TileEntity> tileClass) {
        return IIBlocks.registerBlock(blockClass, null, key, tileClass);
    }

    public static Block registerBlock(Class<? extends Block> blockClass, String key) {
        return IIBlocks.registerBlock(blockClass, null, key, null);
    }

    public static Block registerBlock(Class<? extends Block> blockClass, Class<? extends ItemBlock> itemClass, String key) {
        return IIBlocks.registerBlock(blockClass, itemClass, key, null);
    }
}

