/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import latmod.lib.LMStringUtils;

public class LMFileUtils {
    public static final File latmodHomeFolder = LMFileUtils.getFolder();
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final double KB_D = 1024.0;
    public static final double MB_D = 1048576.0;
    public static final double GB_D = 1.073741824E9;
    public static final Comparator<File> fileComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    public static final Comparator<File> deepFileComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getAbsolutePath().compareToIgnoreCase(o2.getAbsolutePath());
        }
    };

    private static File getFolder() {
        return new File(System.getProperty("user.home"), "/LatMod/");
    }

    public static File newFile(File f) {
        if (f == null || f.exists()) {
            return f;
        }
        try {
            File pf = f.getParentFile();
            if (!pf.exists()) {
                pf.mkdirs();
            }
            f.createNewFile();
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return f;
        }
    }

    public static void save(File f, List<String> al) throws Exception {
        LMFileUtils.save(f, LMStringUtils.fromStringList(al));
    }

    public static void save(File f, String s) throws Exception {
        FileWriter fw = new FileWriter(LMFileUtils.newFile(f));
        BufferedWriter br = new BufferedWriter(fw);
        br.write(s);
        br.close();
        fw.close();
    }

    public static List<String> load(File f) throws Exception {
        return LMStringUtils.readStringList(new FileInputStream(f));
    }

    public static String loadAsText(File f) throws Exception {
        return LMStringUtils.readString(new FileInputStream(f));
    }

    public static boolean downloadFile(String url, File out) {
        try {
            URL website = new URL(url);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(out);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<File> listAll(File f) {
        ArrayList<File> l = new ArrayList<File>();
        LMFileUtils.addAllFiles(l, f);
        return l;
    }

    private static void addAllFiles(ArrayList<File> l, File f) {
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            if (fl != null && fl.length > 0) {
                for (File aFl : fl) {
                    LMFileUtils.addAllFiles(l, aFl);
                }
            }
        } else if (f.isFile()) {
            l.add(f);
        }
    }

    public static long getSize(File f) {
        if (f == null || !f.exists()) {
            return 0L;
        }
        if (f.isFile()) {
            return f.length();
        }
        if (f.isDirectory()) {
            long length = 0L;
            File[] f1 = f.listFiles();
            if (f1 != null && f1.length > 0) {
                for (File aF1 : f1) {
                    length += LMFileUtils.getSize(aF1);
                }
            }
            return length;
        }
        return 0L;
    }

    public static String getSizeS(double b) {
        if (b >= 1.073741824E9) {
            b /= 1.073741824E9;
            b = (double)((long)(b * 10.0)) / 10.0;
            return b + "GB";
        }
        if (b >= 1048576.0) {
            b /= 1048576.0;
            b = (double)((long)(b * 10.0)) / 10.0;
            return b + "MB";
        }
        if (b >= 1024.0) {
            b /= 1024.0;
            b = (double)((long)(b * 10.0)) / 10.0;
            return b + "KB";
        }
        return b + "B";
    }

    public static String getSizeS(File f) {
        return LMFileUtils.getSizeS(LMFileUtils.getSize(f));
    }

    public static Exception copyFile(File src, File dst) {
        if (src != null && dst != null && src.exists() && !src.equals(dst)) {
            if (src.isDirectory() && dst.isDirectory()) {
                for (File f : LMFileUtils.listAll(src)) {
                    File dst1;
                    Exception e = LMFileUtils.copyFile(f, dst1 = new File(dst.getAbsolutePath() + File.separatorChar + f.getAbsolutePath().replace(src.getAbsolutePath(), "")));
                    if (e == null) continue;
                    return e;
                }
                return null;
            }
            dst = LMFileUtils.newFile(dst);
            try {
                FileChannel srcC = new FileInputStream(src).getChannel();
                FileChannel dstC = new FileOutputStream(dst).getChannel();
                dstC.transferFrom(srcC, 0L, srcC.size());
                srcC.close();
                dstC.close();
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }
        return null;
    }

    public static boolean delete(File f) {
        String[] files;
        if (f == null || !f.exists()) {
            return false;
        }
        if (f.isFile()) {
            return f.delete();
        }
        for (String file : files = f.list()) {
            LMFileUtils.delete(new File(f, file));
        }
        return f.delete();
    }

    public static File getSourceDirectory(Class<?> c) {
        return new File(c.getProtectionDomain().getCodeSource().getLocation().getFile());
    }

    public static String getRawFileName(File f) {
        if (f == null || !f.exists()) {
            return null;
        }
        if (f.isDirectory()) {
            return f.getName();
        }
        if (f.isFile()) {
            String s = f.getName();
            return s.substring(0, s.lastIndexOf(46));
        }
        return null;
    }
}

