/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.mod.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.EnumMCColor;
import ftb.lib.TextureCoords;
import ftb.lib.api.FTBLibLang;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.callback.ColorSelected;
import ftb.lib.api.gui.callback.IColorCallback;
import ftb.lib.api.gui.widgets.ButtonLM;
import ftb.lib.api.gui.widgets.SliderLM;
import ftb.lib.api.gui.widgets.WidgetLM;
import java.util.List;
import latmod.lib.LMColor;
import latmod.lib.MathHelperLM;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiSelectColor
extends GuiLM {
    public static final ResourceLocation tex = new ResourceLocation("ftbl", "textures/gui/colselector.png");
    public static final ResourceLocation tex_wheel = new ResourceLocation("ftbl", "textures/gui/colselector_wheel.png");
    public static final TextureCoords col_tex = new TextureCoords(tex, 145, 10, 29, 16);
    public static final TextureCoords cursor_tex = new TextureCoords(tex, 145, 36, 8, 8);
    public static final int SLIDER_W = 6;
    public static final int SLIDER_H = 10;
    public static final int SLIDER_BAR_W = 64;
    public static final TextureCoords slider_tex = new TextureCoords(tex, 145, 26, 6, 10);
    public static final TextureCoords slider_col_tex = new TextureCoords(tex, 145, 0, 64, 10);
    public final IColorCallback callback;
    public final LMColor.HSB initCol;
    public final Object colorID;
    public final boolean isInstant;
    public final LMColor currentColor;
    public final ButtonLM colorInit;
    public final ButtonLM colorCurrent;
    public final SliderLM sliderRed;
    public final SliderLM sliderGreen;
    public final SliderLM sliderBlue;
    public final SliderLM sliderHue;
    public final SliderLM sliderSaturation;
    public final SliderLM sliderBrightness;
    public final ColorSelector colorSelector;

    public GuiSelectColor(IColorCallback cb, LMColor col, Object id, boolean instant) {
        super(null, tex);
        this.callback = cb;
        this.initCol = new LMColor.HSB();
        this.initCol.set(col);
        this.currentColor = new LMColor.RGB();
        this.colorID = id;
        this.isInstant = instant;
        this.mainPanel.width = 143;
        this.mainPanel.height = 93;
        this.colorInit = new ButtonLM(this, 76, 71, col_tex.widthI(), col_tex.heightI()){

            @Override
            public void onButtonPressed(int b) {
                GuiSelectColor.this.closeGui(false);
            }

            @Override
            public void addMouseOverText(List<String> s) {
                s.add(FTBLibLang.button_cancel.format(new Object[0]));
                s.add(GuiSelectColor.this.initCol.toString());
            }
        };
        this.colorCurrent = new ButtonLM(this, 109, 71, col_tex.widthI(), col_tex.heightI()){

            @Override
            public void onButtonPressed(int b) {
                GuiSelectColor.this.closeGui(true);
            }

            @Override
            public void addMouseOverText(List<String> s) {
                s.add(FTBLibLang.button_accept.format(new Object[0]));
                s.add(GuiSelectColor.this.currentColor.toString());
            }
        };
        this.sliderRed = new SliderLM(this, 6, 6, 64, 10, 6){

            @Override
            public void onMoved() {
                GuiSelectColor.this.setColor(new LMColor.RGB((int)(this.value * 255.0f), GuiSelectColor.this.currentColor.green(), GuiSelectColor.this.currentColor.blue()));
            }
        };
        this.sliderRed.displayMax = 255;
        this.sliderRed.title = EnumMCColor.RED.toString();
        this.sliderRed.scrollStep = 0.003921569f;
        this.sliderGreen = new SliderLM(this, 6, 19, 64, 10, 6){

            @Override
            public void onMoved() {
                GuiSelectColor.this.setColor(new LMColor.RGB(GuiSelectColor.this.currentColor.red(), (int)(this.value * 255.0f), GuiSelectColor.this.currentColor.blue()));
            }
        };
        this.sliderGreen.displayMax = 255;
        this.sliderGreen.title = EnumMCColor.GREEN.toString();
        this.sliderGreen.scrollStep = 0.003921569f;
        this.sliderBlue = new SliderLM(this, 6, 32, 64, 10, 6){

            @Override
            public void onMoved() {
                GuiSelectColor.this.setColor(new LMColor.RGB(GuiSelectColor.this.currentColor.red(), GuiSelectColor.this.currentColor.green(), (int)(this.value * 255.0f)));
            }
        };
        this.sliderBlue.displayMax = 255;
        this.sliderBlue.title = EnumMCColor.BLUE.toString();
        this.sliderBlue.scrollStep = 0.003921569f;
        this.sliderHue = new SliderLM(this, 6, 51, 64, 10, 6){

            @Override
            public void onMoved() {
                GuiSelectColor.this.setColor(new LMColor.HSB(this.value, GuiSelectColor.this.currentColor.saturation(), GuiSelectColor.this.currentColor.brightness()));
            }
        };
        this.sliderHue.displayMax = 255;
        this.sliderHue.title = "Hue";
        this.sliderHue.scrollStep = 0.003921569f;
        this.sliderSaturation = new SliderLM(this, 6, 64, 64, 10, 6){

            @Override
            public void onMoved() {
                GuiSelectColor.this.setColor(new LMColor.HSB(GuiSelectColor.this.currentColor.hue(), this.value, GuiSelectColor.this.currentColor.brightness()));
            }
        };
        this.sliderSaturation.displayMax = 255;
        this.sliderSaturation.title = "Saturation";
        this.sliderSaturation.scrollStep = 0.003921569f;
        this.sliderBrightness = new SliderLM(this, 6, 77, 64, 10, 6){

            @Override
            public void onMoved() {
                GuiSelectColor.this.setColor(new LMColor.HSB(GuiSelectColor.this.currentColor.hue(), GuiSelectColor.this.currentColor.saturation(), this.value));
            }
        };
        this.sliderBrightness.displayMax = 255;
        this.sliderBrightness.title = "Brightness";
        this.sliderBrightness.scrollStep = 0.003921569f;
        this.colorSelector = new ColorSelector(this, 75, 5, 64, 64);
        this.setColor(this.initCol);
    }

    @Override
    public void addWidgets() {
        this.mainPanel.add(this.colorInit);
        this.mainPanel.add(this.colorCurrent);
        this.mainPanel.add(this.sliderRed);
        this.mainPanel.add(this.sliderGreen);
        this.mainPanel.add(this.sliderBlue);
        this.mainPanel.add(this.sliderHue);
        this.mainPanel.add(this.sliderSaturation);
        this.mainPanel.add(this.sliderBrightness);
        this.mainPanel.add(this.colorSelector);
    }

    public void setColor(LMColor col) {
        if ((0xFF000000 | this.currentColor.color()) == (0xFF000000 | col.color())) {
            return;
        }
        this.currentColor.set(col);
        this.sliderRed.value = (float)this.currentColor.red() / 255.0f;
        this.sliderGreen.value = (float)this.currentColor.green() / 255.0f;
        this.sliderBlue.value = (float)this.currentColor.blue() / 255.0f;
        this.sliderHue.value = this.currentColor.hue();
        this.sliderSaturation.value = this.currentColor.saturation();
        this.sliderBrightness.value = this.currentColor.brightness();
        this.colorSelector.cursorPosX = Math.cos((double)this.sliderHue.value * (Math.PI * 2)) * 0.5 * (double)this.sliderSaturation.value + 0.5;
        this.colorSelector.cursorPosY = Math.sin((double)this.sliderHue.value * (Math.PI * 2)) * 0.5 * (double)this.sliderSaturation.value + 0.5;
        if (this.isInstant) {
            this.callback.onColorSelected(new ColorSelected(this.colorID, true, this.currentColor, false));
        }
    }

    @Override
    public void drawBackground() {
        this.sliderRed.update();
        this.sliderGreen.update();
        this.sliderBlue.update();
        this.sliderHue.update();
        this.sliderSaturation.update();
        this.sliderBrightness.update();
        super.drawBackground();
        FTBLibClient.setGLColor(this.initCol.color(), 255);
        this.colorInit.render(col_tex);
        FTBLibClient.setGLColor(this.currentColor.color(), 255);
        this.colorCurrent.render(col_tex);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        FTBLibClient.setTexture(tex);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.shadeModel(7425);
        LMColor col1 = new LMColor.RGB();
        LMColor col2 = new LMColor.RGB();
        col1.setRGBA(0, this.currentColor.green(), this.currentColor.blue(), 255);
        col2.setRGBA(255, this.currentColor.green(), this.currentColor.blue(), 255);
        this.renderSlider(this.sliderRed, col1, col2);
        col1.setRGBA(this.currentColor.red(), 0, this.currentColor.blue(), 255);
        col2.setRGBA(this.currentColor.red(), 255, this.currentColor.blue(), 255);
        this.renderSlider(this.sliderGreen, col1, col2);
        col1.setRGBA(this.currentColor.red(), this.currentColor.green(), 0, 255);
        col2.setRGBA(this.currentColor.red(), this.currentColor.green(), 255, 255);
        this.renderSlider(this.sliderBlue, col1, col2);
        col1 = new LMColor.HSB();
        col2 = new LMColor.HSB();
        col1.setHSB(this.currentColor.hue(), this.currentColor.saturation(), this.currentColor.brightness());
        col2.setHSB(this.currentColor.hue(), this.currentColor.saturation(), this.currentColor.brightness());
        this.renderSlider(this.sliderHue, col1, col2);
        col1.setHSB(this.currentColor.hue(), 0.0f, this.currentColor.brightness());
        col2.setHSB(this.currentColor.hue(), 1.0f, this.currentColor.brightness());
        this.renderSlider(this.sliderSaturation, col1, col2);
        col1.setHSB(this.currentColor.hue(), this.currentColor.saturation(), 0.0f);
        col2.setHSB(this.currentColor.hue(), this.currentColor.saturation(), 1.0f);
        this.renderSlider(this.sliderBrightness, col1, col2);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.shadeModel(7424);
        this.colorSelector.renderWidget();
        this.sliderRed.renderSlider(slider_tex);
        this.sliderGreen.renderSlider(slider_tex);
        this.sliderBlue.renderSlider(slider_tex);
        this.sliderHue.renderSlider(slider_tex);
        this.sliderSaturation.renderSlider(slider_tex);
        this.sliderBrightness.renderSlider(slider_tex);
    }

    public void renderSlider(WidgetLM widget, LMColor colLeft, LMColor colRight) {
        int x = widget.getAX();
        int y = widget.getAY();
        double w = widget.width;
        double h = widget.height;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78378_d(colLeft.color());
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, GuiSelectColor.slider_col_tex.minU, GuiSelectColor.slider_col_tex.minV);
        tessellator.func_78374_a((double)(x + 0), (double)y + h, (double)this.field_73735_i, GuiSelectColor.slider_col_tex.minU, GuiSelectColor.slider_col_tex.maxV);
        tessellator.func_78378_d(colRight.color());
        tessellator.func_78374_a((double)x + w, (double)y + h, (double)this.field_73735_i, GuiSelectColor.slider_col_tex.maxU, GuiSelectColor.slider_col_tex.maxV);
        tessellator.func_78374_a((double)x + w, (double)(y + 0), (double)this.field_73735_i, GuiSelectColor.slider_col_tex.maxU, GuiSelectColor.slider_col_tex.minV);
        tessellator.func_78381_a();
    }

    public void closeGui(boolean set) {
        FTBLibClient.playClickSound();
        this.callback.onColorSelected(new ColorSelected(this.colorID, set, set ? this.currentColor : this.initCol, true));
    }

    public static class ColorSelector
    extends WidgetLM {
        public final GuiSelectColor gui;
        public boolean grabbed = false;
        public double cursorPosX = 0.0;
        public double cursorPosY = 0.0;

        public ColorSelector(GuiSelectColor g, int x, int y, int w, int h) {
            super(g, x, y, w, h);
            this.gui = g;
            this.cursorPosY = -1.0;
            this.cursorPosX = -1.0;
        }

        @Override
        public void renderWidget() {
            int ax = this.getAX();
            int ay = this.getAY();
            if (this.grabbed && !Mouse.isButtonDown((int)0)) {
                this.grabbed = false;
            }
            if (this.grabbed) {
                this.cursorPosX = (double)(this.gui.mouse().x - ax) / (double)this.width;
                this.cursorPosY = (double)(this.gui.mouse().y - ay) / (double)this.height;
                double s = MathHelperLM.dist(this.cursorPosX, this.cursorPosY, 0.0, 0.5, 0.5, 0.0) * 2.0;
                if (s > 1.0) {
                    this.cursorPosX = (this.cursorPosX - 0.5) / s + 0.5;
                    this.cursorPosY = (this.cursorPosY - 0.5) / s + 0.5;
                    s = 1.0;
                }
                this.cursorPosX = MathHelperLM.clamp(this.cursorPosX, 0.0, 1.0);
                this.cursorPosY = MathHelperLM.clamp(this.cursorPosY, 0.0, 1.0);
                double h = Math.atan2(this.cursorPosY - 0.5, this.cursorPosX - 0.5) / (Math.PI * 2);
                this.gui.setColor(new LMColor.HSB((float)h, (float)s, this.gui.sliderBrightness.value));
            }
            GlStateManager.enableBlend();
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            FTBLibClient.setTexture(tex_wheel);
            GuiLM.drawTexturedRectD(ax, ay, this.gui.field_73735_i, this.width, this.height, 0.0, 0.0, 1.0, 1.0);
            if (this.cursorPosX >= 0.0 && this.cursorPosY >= 0.0) {
                GlStateManager.color(1.0f - this.gui.sliderRed.value, 1.0f - this.gui.sliderGreen.value, 1.0f - this.gui.sliderBlue.value, 1.0f);
                GuiLM.render(cursor_tex, (double)ax + this.cursorPosX * (double)this.width - 2.0, (double)ay + this.cursorPosY * (double)this.height - 2.0, this.gui.getZLevel(), 4.0, 4.0);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        @Override
        public void mousePressed(int b) {
            if (b == 0 && this.mouseOver()) {
                this.grabbed = true;
            }
        }
    }
}

