/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigType;
import latmod.lib.ByteIOStream;
import latmod.lib.MathHelperLM;
import latmod.lib.annotations.INumberBoundsContainer;

public class ConfigEntryInt
extends ConfigEntry
implements INumberBoundsContainer {
    public int defValue;
    private int value;
    private Integer minValue;
    private Integer maxValue;

    public ConfigEntryInt(String id, int def) {
        super(id);
        this.defValue = def;
        this.set(def);
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.INT;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    @Override
    public void setBounds(double min, double max) {
        this.minValue = min == Double.NEGATIVE_INFINITY ? null : Integer.valueOf((int)min);
        this.maxValue = max == Double.POSITIVE_INFINITY ? null : Integer.valueOf((int)max);
    }

    @Override
    public double getMin() {
        return this.minValue == null ? Double.NEGATIVE_INFINITY : this.minValue.doubleValue();
    }

    @Override
    public double getMax() {
        return this.maxValue == null ? Double.POSITIVE_INFINITY : this.maxValue.doubleValue();
    }

    public void set(int v) {
        this.value = MathHelperLM.clampInt(v, (int)this.getMin(), (int)this.getMax());
    }

    public int get() {
        return this.value;
    }

    public void add(int i) {
        this.set(this.get() + i);
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        this.set(o == null || o.isJsonNull() ? this.defValue : o.getAsInt());
    }

    @Override
    public final JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.get());
    }

    @Override
    public void write(ByteIOStream io) {
        io.writeInt(this.get());
    }

    @Override
    public void read(ByteIOStream io) {
        this.set(io.readInt());
    }

    @Override
    public void writeExtended(ByteIOStream io) {
        this.write(io);
        io.writeInt(this.defValue);
        io.writeDouble(this.getMin());
        io.writeDouble(this.getMax());
    }

    @Override
    public void readExtended(ByteIOStream io) {
        this.read(io);
        this.defValue = io.readInt();
        double min = io.readDouble();
        double max = io.readDouble();
        this.setBounds(min, max);
    }

    @Override
    public String getAsString() {
        return Integer.toString(this.get());
    }

    @Override
    public boolean getAsBoolean() {
        return this.get() == 1;
    }

    @Override
    public int getAsInt() {
        return this.get();
    }

    @Override
    public double getAsDouble() {
        return this.get();
    }

    @Override
    public String getDefValueString() {
        return Integer.toString(this.defValue);
    }

    @Override
    public String getMinValueString() {
        double d = this.getMin();
        if (d != Double.NEGATIVE_INFINITY) {
            return Integer.toString((int)d);
        }
        return null;
    }

    @Override
    public String getMaxValueString() {
        double d = this.getMax();
        if (d != Double.POSITIVE_INFINITY) {
            return Integer.toString((int)d);
        }
        return null;
    }
}

