/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.FTBLib;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.client.model.Face;
import ftb.lib.api.client.model.Group;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class OBJModel {
    public final List<Face> totalFaces = new ArrayList<Face>();
    public final List<Vector3f> vertices = new ArrayList<Vector3f>();
    public final List<Vector3f> vertexNormals = new ArrayList<Vector3f>();
    public final List<Vector3f> texVertices = new ArrayList<Vector3f>();
    public final HashMap<String, Group> groups = new HashMap();
    private Group current = null;
    public double sizeV = 0.0;

    protected OBJModel() {
    }

    public static OBJModel load(ResourceLocation rl) {
        try {
            return OBJModel.load(OBJModel.class.getResourceAsStream(FTBLib.getPath(rl)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OBJModel load(InputStream is) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        OBJModel m = new OBJModel();
        if (br.ready()) {
            double minSizeV = Double.POSITIVE_INFINITY;
            double maxSizeV = Double.NEGATIVE_INFINITY;
            String s = null;
            while ((s = br.readLine()) != null) {
                Face f;
                float z;
                float y;
                if (s.length() <= 0 || s.charAt(0) == '#') continue;
                String[] s3 = s.split(" ");
                if (s3[0].equals("o")) {
                    Group g = new Group(m, s3[1]);
                    if (m.current != null) {
                        m.groups.put(m.current.groupName, m.current);
                    }
                    m.current = g;
                    continue;
                }
                if (s3[0].equals("g") || s3[0].equals("s") || s3[0].equals("mtllib") || s3[0].equals("usemtl")) continue;
                if (s3[0].equals("v")) {
                    float x = Float.parseFloat(s3[1]);
                    y = Float.parseFloat(s3[2]);
                    z = Float.parseFloat(s3[3]);
                    m.vertices.add(new Vector3f(x, y, z));
                    if ((double)y < minSizeV) {
                        minSizeV = y;
                    }
                    if (!((double)y > maxSizeV)) continue;
                    maxSizeV = y;
                    continue;
                }
                if (s3[0].equals("vn")) {
                    float x = Float.parseFloat(s3[1]);
                    y = Float.parseFloat(s3[2]);
                    z = Float.parseFloat(s3[3]);
                    m.vertexNormals.add(new Vector3f(x, y, z));
                    continue;
                }
                if (s3[0].equals("vt")) {
                    if (s3.length == 3) {
                        float x = Float.parseFloat(s3[1]);
                        y = Float.parseFloat(s3[2]);
                        m.texVertices.add(new Vector3f(x, 1.0f - y, -1.0f));
                        continue;
                    }
                    if (s3.length != 4) continue;
                    float x = Float.parseFloat(s3[1]);
                    y = Float.parseFloat(s3[2]);
                    z = Float.parseFloat(s3[3]);
                    m.texVertices.add(new Vector3f(x, 1.0f - y, z));
                    continue;
                }
                if (!s3[0].equals("f")) continue;
                if (m.current == null) {
                    m.current = new Group(m, "Default");
                }
                if ((f = Face.parseFace(m, s, s3)) == null) continue;
                m.current.faces.add(f);
                m.totalFaces.add(f);
            }
            m.groups.put(m.current.groupName, m.current);
            m.sizeV = maxSizeV - minSizeV;
        }
        if (m != null && m.texVertices != null) {
            GlStateManager.enableTexture2D();
        } else {
            GlStateManager.disableTexture2D();
        }
        m.renderAll();
        return m;
    }

    public void renderAll() {
        for (int i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).render();
        }
    }

    public void render(int ... index) {
        for (int i = 0; i < index.length; ++i) {
            if (index[i] < 0 || index[i] >= this.groups.size()) continue;
            this.groups.get(index[i]).render();
        }
    }

    public void renderAllExcept(int ... index) {
        for (int i = 0; i < this.groups.size(); ++i) {
            for (int j = 0; j < index.length; ++j) {
                if (i != index[j]) continue;
            }
            this.groups.get(i).render();
        }
    }

    public void render(String ... name) {
        for (int i = 0; i < name.length; ++i) {
            int index = this.getGroupIndex(name[i]);
            if (index < 0 || index >= this.groups.size()) continue;
            this.groups.get(index).render();
        }
    }

    public int getGroupIndex(String s) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.groups.get((Object)Integer.valueOf((int)i)).groupName.equalsIgnoreCase(s)) continue;
            return i;
        }
        return -1;
    }

    public OBJModel copy(boolean render) {
        OBJModel m = new OBJModel();
        m.vertices.addAll(this.vertices);
        m.texVertices.addAll(this.texVertices);
        m.vertexNormals.addAll(this.vertexNormals);
        m.groups.putAll(this.groups);
        m.totalFaces.addAll(this.totalFaces);
        m.sizeV = this.sizeV;
        if (render) {
            if (m != null && m.texVertices != null) {
                GlStateManager.enableTexture2D();
            } else {
                GlStateManager.disableTexture2D();
            }
            m.renderAll();
        }
        return m;
    }
}

