/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.FTBLib;
import ftb.lib.TempLMPlayerFromEntity;
import ftb.lib.TextureCoords;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.friends.ILMPlayer;
import ftb.lib.api.gui.IClientActionGui;
import ftb.lib.api.gui.callback.ClientTickCallback;
import ftb.lib.mod.client.FTBLibRenderHandler;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.UUID;
import latmod.lib.LMColorUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.BufferUtils;

@SideOnly(value=Side.CLIENT)
public class FTBLibClient {
    public static final Minecraft mc = FMLClientHandler.instance().getClient();
    private static final HashMap<String, ResourceLocation> cachedSkins = new HashMap();
    private static final ResourceLocation clickSound = new ResourceLocation("gui.button.press");
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    private static EntityItem entityItem;
    public static int displayW;
    public static int displayH;
    public static IIcon blockNullIcon;

    public static int getNewBlockRenderID() {
        return RenderingRegistry.getNextAvailableRenderId();
    }

    public static void addBlockRenderer(int i, ISimpleBlockRenderingHandler r) {
        RenderingRegistry.registerBlockHandler((int)i, (ISimpleBlockRenderingHandler)r);
    }

    public static void addItemRenderer(Item item, IItemRenderer i) {
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)i);
    }

    public static void addItemRenderer(Block block, IItemRenderer i) {
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)i);
    }

    public static <T extends Entity> void addEntityRenderer(Class<T> c, Render r) {
        RenderingRegistry.registerEntityRenderingHandler(c, (Render)r);
    }

    public static void addTileRenderer(Class<? extends TileEntity> c, TileEntitySpecialRenderer r) {
        ClientRegistry.bindTileEntitySpecialRenderer(c, (TileEntitySpecialRenderer)r);
    }

    public static ILMPlayer getClientLMPlayer() {
        ILMPlayer p = FTBLib.ftbu == null ? null : FTBLib.ftbu.getLMPlayer(FTBLibClient.mc.field_71439_g);
        return p == null ? new TempLMPlayerFromEntity(Side.CLIENT, (EntityPlayer)FTBLibClient.mc.field_71439_g) : p;
    }

    public static boolean isIngame() {
        return FTBLibClient.mc.field_71441_e != null && FTBLibClient.mc.field_71439_g != null && FTBLibClient.mc.field_71439_g.field_70170_p != null;
    }

    public static boolean isIngameWithFTBU() {
        return FTBLibClient.isIngame() && FTBLib.ftbu != null && FTBLib.ftbu.hasClientWorld();
    }

    public static int getDim() {
        return FTBLibClient.isIngame() ? FTBLibClient.mc.field_71441_e.field_73011_w.field_76574_g : 0;
    }

    public static UUID getUUID() {
        return mc.func_110432_I().func_148256_e().getId();
    }

    public static void spawnPart(EntityFX e) {
        FTBLibClient.mc.field_71452_i.func_78873_a(e);
    }

    public static KeyBinding addKeyBinding(String name, int key, String cat) {
        KeyBinding k = new KeyBinding(name, key, cat);
        ClientRegistry.registerKeyBinding((KeyBinding)k);
        return k;
    }

    public static void onGuiClientAction() {
        if (FTBLibClient.mc.field_71462_r instanceof IClientActionGui) {
            ((IClientActionGui)FTBLibClient.mc.field_71462_r).onClientDataChanged();
        }
    }

    public static void pushMaxBrightness() {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void popMaxBrightness() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static EntityPlayerSP getPlayerSP(UUID uuid) {
        EntityPlayer ep;
        if (uuid == null) {
            return FTBLibClient.mc.field_71439_g;
        }
        if (FTBLibClient.mc.field_71441_e != null && (ep = FTBLibClient.mc.field_71441_e.func_152378_a(uuid)) != null && ep instanceof EntityPlayerSP) {
            return (EntityPlayerSP)ep;
        }
        return null;
    }

    public static ThreadDownloadImageData getDownloadImage(ResourceLocation out, String url, ResourceLocation def, IImageBuffer buffer) {
        TextureManager t = mc.func_110434_K();
        ThreadDownloadImageData img = (ThreadDownloadImageData)t.func_110581_b(out);
        if (img == null) {
            img = new ThreadDownloadImageData(null, url, def, buffer);
            t.func_110579_a(out, (ITextureObject)img);
        }
        return img;
    }

    public static void playClickSound() {
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)clickSound, (float)1.0f));
    }

    public static void setGLColor(int c, int a) {
        int r = LMColorUtils.getRed(c);
        int g = LMColorUtils.getGreen(c);
        int b = LMColorUtils.getBlue(c);
        GlStateManager.color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public static void setGLColor(int c) {
        FTBLibClient.setGLColor(c, LMColorUtils.getAlpha(c));
    }

    public static ByteBuffer toByteBuffer(int[] pixels, boolean alpha) {
        if (pixels == null) {
            return null;
        }
        ByteBuffer bb = BufferUtils.createByteBuffer((int)(pixels.length * 4));
        byte alpha255 = -1;
        for (int p : pixels) {
            bb.put((byte)LMColorUtils.getRed(p));
            bb.put((byte)LMColorUtils.getGreen(p));
            bb.put((byte)LMColorUtils.getBlue(p));
            bb.put(alpha ? (byte)LMColorUtils.getAlpha(p) : alpha255);
        }
        bb.flip();
        return bb;
    }

    public static void execClientCommand(String s) {
        FTBLibClient.mc.field_71456_v.func_146158_b().func_146239_a(s);
        if (ClientCommandHandler.instance.func_71556_a((ICommandSender)FTBLibClient.mc.field_71439_g, s) == 0) {
            FTBLibClient.mc.field_71439_g.func_71165_d(s);
        }
    }

    public static ResourceLocation getSkinTexture(String username) {
        ResourceLocation r = cachedSkins.get(username);
        if (r == null) {
            r = AbstractClientPlayer.func_110311_f((String)username);
            try {
                AbstractClientPlayer.func_110304_a((ResourceLocation)r, (String)username);
                cachedSkins.put(username, r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    public static void setTexture(TextureCoords tex) {
        if (tex != null) {
            FTBLibClient.setTexture(tex.texture);
        }
    }

    public static void setTexture(ResourceLocation tex) {
        if (tex != null) {
            mc.func_110434_K().func_110577_a(tex);
        }
    }

    public static void clearCachedData() {
        cachedSkins.clear();
    }

    public static boolean canRenderGui() {
        return FTBLibClient.mc.field_71462_r == null || FTBLibClient.mc.field_71462_r instanceof GuiChat;
    }

    public static void addClientTickCallback(ClientTickCallback e) {
        FTBLibRenderHandler.callbacks.add(e);
    }

    public static void renderItem(World w, ItemStack is) {
        if (w == null || is == null) {
            return;
        }
        if (entityItem == null) {
            entityItem = new EntityItem(w);
        }
        FTBLibClient.entityItem.field_70170_p = w;
        FTBLibClient.entityItem.field_70290_d = 0.0f;
        entityItem.func_92058_a(is);
        RenderManager.field_78727_a.func_147940_a((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
    }

    public static void openGui(GuiScreen gui) {
        if (gui == null && FTBLibClient.mc.field_71439_g != null) {
            FTBLibClient.mc.field_71439_g.func_71053_j();
        } else {
            mc.func_147108_a(gui);
        }
    }

    public static void renderGuiItem(ItemStack is, RenderItem itemRender, FontRenderer font, int x, int y) {
        if (is == null || is.func_77973_b() == null) {
            return;
        }
        GlStateManager.pushAttrib();
        GlStateManager.pushMatrix();
        GlStateManager.enableLighting();
        RenderHelper.func_74520_c();
        GlStateManager.enableRescaleNormal();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        FontRenderer f = is.func_77973_b().getFontRenderer(is);
        if (f == null) {
            f = font;
        }
        itemRender.func_82406_b(f, mc.func_110434_K(), is, x, y);
        itemRender.func_94148_a(f, mc.func_110434_K(), is, x, y, null);
        GlStateManager.popMatrix();
        GlStateManager.popAttrib();
    }

    static {
        blockNullIcon = null;
    }
}

